// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for SkuName. */
public enum SkuName {
    /** Enum value free. */
    FREE("free"),

    /** Enum value basic. */
    BASIC("basic"),

    /** Enum value standard. */
    STANDARD("standard"),

    /** Enum value standard2. */
    STANDARD2("standard2"),

    /** Enum value standard3. */
    STANDARD3("standard3"),

    /** Enum value storage_optimized_l1. */
    STORAGE_OPTIMIZED_L1("storage_optimized_l1"),

    /** Enum value storage_optimized_l2. */
    STORAGE_OPTIMIZED_L2("storage_optimized_l2");

    /** The actual serialized value for a SkuName instance. */
    private final String value;

    SkuName(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a SkuName instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed SkuName object, or null if unable to parse.
     */
    @JsonCreator
    public static SkuName fromString(String value) {
        SkuName[] items = SkuName.values();
        for (SkuName item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
