// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Describes the properties of a supported private link resource for the search service. For a given API version, this
 * represents the 'supported' groupIds when creating a shared private link resource.
 */
@Immutable
public final class PrivateLinkResourceProperties {
    /*
     * The group ID of the private link resource.
     */
    @JsonProperty(value = "groupId", access = JsonProperty.Access.WRITE_ONLY)
    private String groupId;

    /*
     * The list of required members of the private link resource.
     */
    @JsonProperty(value = "requiredMembers", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> requiredMembers;

    /*
     * The list of required DNS zone names of the private link resource.
     */
    @JsonProperty(value = "requiredZoneNames", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> requiredZoneNames;

    /*
     * The list of resources that are onboarded to private link service and that are supported by search.
     */
    @JsonProperty(value = "shareablePrivateLinkResourceTypes", access = JsonProperty.Access.WRITE_ONLY)
    private List<ShareablePrivateLinkResourceType> shareablePrivateLinkResourceTypes;

    /** Creates an instance of PrivateLinkResourceProperties class. */
    public PrivateLinkResourceProperties() {
    }

    /**
     * Get the groupId property: The group ID of the private link resource.
     *
     * @return the groupId value.
     */
    public String groupId() {
        return this.groupId;
    }

    /**
     * Get the requiredMembers property: The list of required members of the private link resource.
     *
     * @return the requiredMembers value.
     */
    public List<String> requiredMembers() {
        return this.requiredMembers;
    }

    /**
     * Get the requiredZoneNames property: The list of required DNS zone names of the private link resource.
     *
     * @return the requiredZoneNames value.
     */
    public List<String> requiredZoneNames() {
        return this.requiredZoneNames;
    }

    /**
     * Get the shareablePrivateLinkResourceTypes property: The list of resources that are onboarded to private link
     * service and that are supported by search.
     *
     * @return the shareablePrivateLinkResourceTypes value.
     */
    public List<ShareablePrivateLinkResourceType> shareablePrivateLinkResourceTypes() {
        return this.shareablePrivateLinkResourceTypes;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (shareablePrivateLinkResourceTypes() != null) {
            shareablePrivateLinkResourceTypes().forEach(e -> e.validate());
        }
    }
}
