// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes the properties of a resource type that has been onboarded to private link service and that's supported by
 * search.
 */
@Immutable
public final class ShareablePrivateLinkResourceProperties {
    /*
     * The resource provider type for the resource that has been onboarded to private link service and that's supported
     * by search.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * The resource provider group id for the resource that has been onboarded to private link service and that's
     * supported by search.
     */
    @JsonProperty(value = "groupId", access = JsonProperty.Access.WRITE_ONLY)
    private String groupId;

    /*
     * The description of the resource type that has been onboarded to private link service and that's supported by
     * search.
     */
    @JsonProperty(value = "description", access = JsonProperty.Access.WRITE_ONLY)
    private String description;

    /** Creates an instance of ShareablePrivateLinkResourceProperties class. */
    public ShareablePrivateLinkResourceProperties() {
    }

    /**
     * Get the type property: The resource provider type for the resource that has been onboarded to private link
     * service and that's supported by search.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the groupId property: The resource provider group id for the resource that has been onboarded to private link
     * service and that's supported by search.
     *
     * @return the groupId value.
     */
    public String groupId() {
        return this.groupId;
    }

    /**
     * Get the description property: The description of the resource type that has been onboarded to private link
     * service and that's supported by search.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
