// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Output of check name availability API. */
@Immutable
public final class CheckNameAvailabilityOutput {
    /*
     * A value indicating whether the name is available.
     */
    @JsonProperty(value = "nameAvailable", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isNameAvailable;

    /*
     * The reason why the name is not available. 'Invalid' indicates the name provided does not match the naming
     * requirements (incorrect length, unsupported characters, etc.). 'AlreadyExists' indicates that the name is
     * already in use and is therefore unavailable.
     */
    @JsonProperty(value = "reason", access = JsonProperty.Access.WRITE_ONLY)
    private UnavailableNameReason reason;

    /*
     * A message that explains why the name is invalid and provides resource naming requirements. Available only if
     * 'Invalid' is returned in the 'reason' property.
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /** Creates an instance of CheckNameAvailabilityOutput class. */
    public CheckNameAvailabilityOutput() {
    }

    /**
     * Get the isNameAvailable property: A value indicating whether the name is available.
     *
     * @return the isNameAvailable value.
     */
    public Boolean isNameAvailable() {
        return this.isNameAvailable;
    }

    /**
     * Get the reason property: The reason why the name is not available. 'Invalid' indicates the name provided does not
     * match the naming requirements (incorrect length, unsupported characters, etc.). 'AlreadyExists' indicates that
     * the name is already in use and is therefore unavailable.
     *
     * @return the reason value.
     */
    public UnavailableNameReason reason() {
        return this.reason;
    }

    /**
     * Get the message property: A message that explains why the name is invalid and provides resource naming
     * requirements. Available only if 'Invalid' is returned in the 'reason' property.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
