// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.search.fluent.models.QuotaUsageResultInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Response containing the quota usage information for all the supported SKUs of Azure AI Search. */
@Immutable
public final class QuotaUsagesListResult {
    /*
     * The quota usages for the SKUs supported by Azure AI Search.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<QuotaUsageResultInner> value;

    /*
     * Request URL that can be used to query next page of quota usages. Returned when the total number of requested
     * quota usages exceed maximum page size.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /** Creates an instance of QuotaUsagesListResult class. */
    public QuotaUsagesListResult() {
    }

    /**
     * Get the value property: The quota usages for the SKUs supported by Azure AI Search.
     *
     * @return the value value.
     */
    public List<QuotaUsageResultInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Request URL that can be used to query next page of quota usages. Returned when the
     * total number of requested quota usages exceed maximum page size.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
