// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.fluent.models.PrivateLinkResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * Response containing a list of supported Private Link Resources.
 */
@Immutable
public final class PrivateLinkResourcesResult implements JsonSerializable<PrivateLinkResourcesResult> {
    /*
     * The list of supported Private Link Resources.
     */
    private List<PrivateLinkResourceInner> value;

    /**
     * Creates an instance of PrivateLinkResourcesResult class.
     */
    public PrivateLinkResourcesResult() {
    }

    /**
     * Get the value property: The list of supported Private Link Resources.
     * 
     * @return the value value.
     */
    public List<PrivateLinkResourceInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateLinkResourcesResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateLinkResourcesResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateLinkResourcesResult.
     */
    public static PrivateLinkResourcesResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateLinkResourcesResult deserializedPrivateLinkResourcesResult = new PrivateLinkResourcesResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PrivateLinkResourceInner> value
                        = reader.readArray(reader1 -> PrivateLinkResourceInner.fromJson(reader1));
                    deserializedPrivateLinkResourcesResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateLinkResourcesResult;
        });
    }
}
