// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

/**
 * Status of the shared private link resource. Valid values are Pending, Approved, Rejected or Disconnected.
 */
public enum SharedPrivateLinkResourceStatus {
    /**
     * Enum value Pending.
     */
    PENDING("Pending"),

    /**
     * Enum value Approved.
     */
    APPROVED("Approved"),

    /**
     * Enum value Rejected.
     */
    REJECTED("Rejected"),

    /**
     * Enum value Disconnected.
     */
    DISCONNECTED("Disconnected");

    /**
     * The actual serialized value for a SharedPrivateLinkResourceStatus instance.
     */
    private final String value;

    SharedPrivateLinkResourceStatus(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a SharedPrivateLinkResourceStatus instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed SharedPrivateLinkResourceStatus object, or null if unable to parse.
     */
    public static SharedPrivateLinkResourceStatus fromString(String value) {
        if (value == null) {
            return null;
        }
        SharedPrivateLinkResourceStatus[] items = SharedPrivateLinkResourceStatus.values();
        for (SharedPrivateLinkResourceStatus item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
