// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a resource type that has been onboarded to private link service and that's supported by search.
 */
@Immutable
public final class ShareablePrivateLinkResourceType implements JsonSerializable<ShareablePrivateLinkResourceType> {
    /*
     * The name of the resource type that has been onboarded to private link service and that's supported by search.
     */
    private String name;

    /*
     * Describes the properties of a resource type that has been onboarded to private link service and that's supported
     * by search.
     */
    private ShareablePrivateLinkResourceProperties properties;

    /**
     * Creates an instance of ShareablePrivateLinkResourceType class.
     */
    public ShareablePrivateLinkResourceType() {
    }

    /**
     * Get the name property: The name of the resource type that has been onboarded to private link service and that's
     * supported by search.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the properties property: Describes the properties of a resource type that has been onboarded to private link
     * service and that's supported by search.
     * 
     * @return the properties value.
     */
    public ShareablePrivateLinkResourceProperties properties() {
        return this.properties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ShareablePrivateLinkResourceType from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ShareablePrivateLinkResourceType if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ShareablePrivateLinkResourceType.
     */
    public static ShareablePrivateLinkResourceType fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ShareablePrivateLinkResourceType deserializedShareablePrivateLinkResourceType
                = new ShareablePrivateLinkResourceType();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedShareablePrivateLinkResourceType.name = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedShareablePrivateLinkResourceType.properties
                        = ShareablePrivateLinkResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedShareablePrivateLinkResourceType;
        });
    }
}
