// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.fluent.models.SharedPrivateLinkResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * Response containing a list of Shared Private Link Resources.
 */
@Fluent
public final class SharedPrivateLinkResourceListResult
    implements JsonSerializable<SharedPrivateLinkResourceListResult> {
    /*
     * The list of Shared Private Link Resources.
     */
    private List<SharedPrivateLinkResourceInner> value;

    /*
     * The URL to get the next set of shared private link resources, if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of SharedPrivateLinkResourceListResult class.
     */
    public SharedPrivateLinkResourceListResult() {
    }

    /**
     * Get the value property: The list of Shared Private Link Resources.
     * 
     * @return the value value.
     */
    public List<SharedPrivateLinkResourceInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: The URL to get the next set of shared private link resources, if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of shared private link resources, if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SharedPrivateLinkResourceListResult object itself.
     */
    public SharedPrivateLinkResourceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharedPrivateLinkResourceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharedPrivateLinkResourceListResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SharedPrivateLinkResourceListResult.
     */
    public static SharedPrivateLinkResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharedPrivateLinkResourceListResult deserializedSharedPrivateLinkResourceListResult
                = new SharedPrivateLinkResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SharedPrivateLinkResourceInner> value
                        = reader.readArray(reader1 -> SharedPrivateLinkResourceInner.fromJson(reader1));
                    deserializedSharedPrivateLinkResourceListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSharedPrivateLinkResourceListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSharedPrivateLinkResourceListResult;
        });
    }
}
