// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Describes an API key for a given Azure Cognitive Search service that has permissions for query operations only. */
@Immutable
public final class QueryKeyInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(QueryKeyInner.class);

    /*
     * The name of the query API key; may be empty.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The value of the query API key.
     */
    @JsonProperty(value = "key", access = JsonProperty.Access.WRITE_ONLY)
    private String key;

    /**
     * Get the name property: The name of the query API key; may be empty.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the key property: The value of the query API key.
     *
     * @return the key value.
     */
    public String key() {
        return this.key;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
