/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.search.fluent.ServicesClient;
import com.azure.resourcemanager.search.fluent.models.SearchServiceInner;
import com.azure.resourcemanager.search.implementation.SearchManagementClientImpl;
import com.azure.resourcemanager.search.models.CheckNameAvailabilityInput;
import com.azure.resourcemanager.search.models.CheckNameAvailabilityOutput;
import com.azure.resourcemanager.search.models.SearchServiceListResult;
import com.azure.resourcemanager.search.models.SearchServiceUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServicesClientImpl
implements InnerSupportsGet<SearchServiceInner>,
InnerSupportsListing<SearchServiceInner>,
InnerSupportsDelete<Void>,
ServicesClient {
    private final ClientLogger logger = new ClientLogger(ServicesClientImpl.class);
    private final ServicesService service;
    private final SearchManagementClientImpl client;

    ServicesClientImpl(SearchManagementClientImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceParam == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceParam is required and cannot be null."));
        }
        serviceParam.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), serviceParam, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceParam == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceParam is required and cannot be null."));
        }
        serviceParam.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), serviceParam, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<SearchServiceInner>, SearchServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SearchServiceInner.class), (Type)((Object)SearchServiceInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<SearchServiceInner>, SearchServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SearchServiceInner.class), (Type)((Object)SearchServiceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<SearchServiceInner>, SearchServiceInner> beginCreateOrUpdate(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<SearchServiceInner>, SearchServiceInner> beginCreateOrUpdate(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchServiceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).last().flatMap(arg_0 -> ((SearchManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchServiceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam) {
        UUID clientRequestId = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).last().flatMap(arg_0 -> ((SearchManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SearchServiceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context).last().flatMap(arg_0 -> ((SearchManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchServiceInner createOrUpdate(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId) {
        return (SearchServiceInner)((Object)this.createOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchServiceInner createOrUpdate(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam) {
        UUID clientRequestId = null;
        return (SearchServiceInner)((Object)this.createOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchServiceInner createOrUpdate(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId, Context context) {
        return (SearchServiceInner)((Object)this.createOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchServiceInner>> updateWithResponseAsync(String resourceGroupName, String searchServiceName, SearchServiceUpdate serviceParam, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceParam == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceParam is required and cannot be null."));
        }
        serviceParam.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), serviceParam, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SearchServiceInner>> updateWithResponseAsync(String resourceGroupName, String searchServiceName, SearchServiceUpdate serviceParam, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceParam == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceParam is required and cannot be null."));
        }
        serviceParam.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), serviceParam, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchServiceInner> updateAsync(String resourceGroupName, String searchServiceName, SearchServiceUpdate serviceParam, UUID clientRequestId) {
        return this.updateWithResponseAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SearchServiceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchServiceInner> updateAsync(String resourceGroupName, String searchServiceName, SearchServiceUpdate serviceParam) {
        UUID clientRequestId = null;
        return this.updateWithResponseAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SearchServiceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchServiceInner update(String resourceGroupName, String searchServiceName, SearchServiceUpdate serviceParam) {
        UUID clientRequestId = null;
        return (SearchServiceInner)((Object)this.updateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchServiceInner> updateWithResponse(String resourceGroupName, String searchServiceName, SearchServiceUpdate serviceParam, UUID clientRequestId, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchServiceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SearchServiceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchServiceInner> getByResourceGroupAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SearchServiceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchServiceInner> getByResourceGroupAsync(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SearchServiceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchServiceInner getByResourceGroup(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        return (SearchServiceInner)((Object)this.getByResourceGroupAsync(resourceGroupName, searchServiceName, clientRequestId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchServiceInner> getByResourceGroupWithResponse(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        return this.deleteWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        return this.deleteWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        this.deleteAsync(resourceGroupName, searchServiceName, clientRequestId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SearchServiceListResult)res.getValue()).value(), ((SearchServiceListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SearchServiceListResult)res.getValue()).value(), ((SearchServiceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SearchServiceInner> listByResourceGroupAsync(String resourceGroupName, UUID clientRequestId) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, clientRequestId), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, clientRequestId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SearchServiceInner> listByResourceGroupAsync(String resourceGroupName) {
        UUID clientRequestId = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, clientRequestId), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, clientRequestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SearchServiceInner> listByResourceGroupAsync(String resourceGroupName, UUID clientRequestId, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, clientRequestId, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, clientRequestId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchServiceInner> listByResourceGroup(String resourceGroupName) {
        UUID clientRequestId = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, clientRequestId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchServiceInner> listByResourceGroup(String resourceGroupName, UUID clientRequestId, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, clientRequestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listSinglePageAsync(UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SearchServiceListResult)res.getValue()).value(), ((SearchServiceListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listSinglePageAsync(UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SearchServiceListResult)res.getValue()).value(), ((SearchServiceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SearchServiceInner> listAsync(UUID clientRequestId) {
        return new PagedFlux(() -> this.listSinglePageAsync(clientRequestId), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, clientRequestId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SearchServiceInner> listAsync() {
        UUID clientRequestId = null;
        return new PagedFlux(() -> this.listSinglePageAsync(clientRequestId), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, clientRequestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SearchServiceInner> listAsync(UUID clientRequestId, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(clientRequestId, context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, clientRequestId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchServiceInner> list() {
        UUID clientRequestId = null;
        return new PagedIterable(this.listAsync(clientRequestId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchServiceInner> list(UUID clientRequestId, Context context) {
        return new PagedIterable(this.listAsync(clientRequestId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CheckNameAvailabilityOutput>> checkNameAvailabilityWithResponseAsync(String name, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String accept = "application/json";
        CheckNameAvailabilityInput checkNameAvailabilityInput = new CheckNameAvailabilityInput();
        checkNameAvailabilityInput.withName(name);
        return FluxUtil.withContext(context -> this.service.checkNameAvailability(this.client.getEndpoint(), clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), checkNameAvailabilityInput, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameAvailabilityOutput>> checkNameAvailabilityWithResponseAsync(String name, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String accept = "application/json";
        CheckNameAvailabilityInput checkNameAvailabilityInput = new CheckNameAvailabilityInput();
        checkNameAvailabilityInput.withName(name);
        context = this.client.mergeContext(context);
        return this.service.checkNameAvailability(this.client.getEndpoint(), clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), checkNameAvailabilityInput, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CheckNameAvailabilityOutput> checkNameAvailabilityAsync(String name, UUID clientRequestId) {
        return this.checkNameAvailabilityWithResponseAsync(name, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CheckNameAvailabilityOutput)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CheckNameAvailabilityOutput> checkNameAvailabilityAsync(String name) {
        UUID clientRequestId = null;
        return this.checkNameAvailabilityWithResponseAsync(name, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CheckNameAvailabilityOutput)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckNameAvailabilityOutput checkNameAvailability(String name) {
        UUID clientRequestId = null;
        return (CheckNameAvailabilityOutput)this.checkNameAvailabilityAsync(name, clientRequestId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckNameAvailabilityOutput> checkNameAvailabilityWithResponse(String name, UUID clientRequestId, Context context) {
        return (Response)this.checkNameAvailabilityWithResponseAsync(name, clientRequestId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listByResourceGroupNextSinglePageAsync(String nextLink, UUID clientRequestId) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), clientRequestId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SearchServiceListResult)res.getValue()).value(), ((SearchServiceListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listByResourceGroupNextSinglePageAsync(String nextLink, UUID clientRequestId, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), clientRequestId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SearchServiceListResult)res.getValue()).value(), ((SearchServiceListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listBySubscriptionNextSinglePageAsync(String nextLink, UUID clientRequestId) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), clientRequestId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SearchServiceListResult)res.getValue()).value(), ((SearchServiceListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listBySubscriptionNextSinglePageAsync(String nextLink, UUID clientRequestId, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), clientRequestId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SearchServiceListResult)res.getValue()).value(), ((SearchServiceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SearchManagementClie")
    private static interface ServicesService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") SearchServiceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SearchServiceInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") SearchServiceUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SearchServiceInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}")
        @ExpectedResponses(value={200, 204, 404})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SearchServiceListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Search/searchServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SearchServiceListResult>> list(@HostParam(value="$host") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Search/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckNameAvailabilityOutput>> checkNameAvailability(@HostParam(value="$host") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") CheckNameAvailabilityInput var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SearchServiceListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SearchServiceListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

