// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Input of check name availability API.
 */
@Fluent
public final class CheckNameAvailabilityInput implements JsonSerializable<CheckNameAvailabilityInput> {
    /*
     * The search service name to validate. Search service names must only contain lowercase letters, digits or dashes,
     * cannot use dash as the first two or last one characters, cannot contain consecutive dashes, and must be between 2
     * and 60 characters in length.
     */
    private String name;

    /*
     * The type of the resource whose name is to be validated. This value must always be 'searchServices'.
     */
    private String type = "searchServices";

    /**
     * Creates an instance of CheckNameAvailabilityInput class.
     */
    public CheckNameAvailabilityInput() {
    }

    /**
     * Get the name property: The search service name to validate. Search service names must only contain lowercase
     * letters, digits or dashes, cannot use dash as the first two or last one characters, cannot contain consecutive
     * dashes, and must be between 2 and 60 characters in length.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The search service name to validate. Search service names must only contain lowercase
     * letters, digits or dashes, cannot use dash as the first two or last one characters, cannot contain consecutive
     * dashes, and must be between 2 and 60 characters in length.
     * 
     * @param name the name value to set.
     * @return the CheckNameAvailabilityInput object itself.
     */
    public CheckNameAvailabilityInput withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of the resource whose name is to be validated. This value must always be
     * 'searchServices'.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the resource whose name is to be validated. This value must always be
     * 'searchServices'.
     * 
     * @param type the type value to set.
     * @return the CheckNameAvailabilityInput object itself.
     */
    public CheckNameAvailabilityInput withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property name in model CheckNameAvailabilityInput"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CheckNameAvailabilityInput.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CheckNameAvailabilityInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CheckNameAvailabilityInput if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CheckNameAvailabilityInput.
     */
    public static CheckNameAvailabilityInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CheckNameAvailabilityInput deserializedCheckNameAvailabilityInput = new CheckNameAvailabilityInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCheckNameAvailabilityInput.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCheckNameAvailabilityInput;
        });
    }
}
