// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.search.fluent.ServicesClient;
import com.azure.resourcemanager.search.fluent.models.SearchServiceInner;
import com.azure.resourcemanager.search.models.CheckNameAvailabilityInput;
import com.azure.resourcemanager.search.models.CheckNameAvailabilityOutput;
import com.azure.resourcemanager.search.models.SearchServiceListResult;
import com.azure.resourcemanager.search.models.SearchServiceUpdate;
import java.nio.ByteBuffer;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ServicesClient.
 */
public final class ServicesClientImpl implements InnerSupportsGet<SearchServiceInner>,
    InnerSupportsListing<SearchServiceInner>, InnerSupportsDelete<Void>, ServicesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ServicesService service;

    /**
     * The service client containing this operation class.
     */
    private final SearchManagementClientImpl client;

    /**
     * Initializes an instance of ServicesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ServicesClientImpl(SearchManagementClientImpl client) {
        this.service = RestProxy.create(ServicesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SearchManagementClientServices to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "SearchManagementClientServices")
    public interface ServicesService {
        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") SearchServiceInner service, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") SearchServiceUpdate service, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SearchServiceInner>> getByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}")
        @ExpectedResponses({ 200, 204, 404 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SearchServiceListResult>> listByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Search/searchServices")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SearchServiceListResult>> list(@HostParam("$host") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Search/checkNameAvailability")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CheckNameAvailabilityOutput>> checkNameAvailability(@HostParam("$host") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") CheckNameAvailabilityInput checkNameAvailabilityInput,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/upgrade")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> upgrade(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SearchServiceListResult>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SearchServiceListResult>> listBySubscriptionNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId, @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceParam == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceParam is required and cannot be null."));
        } else {
            serviceParam.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), resourceGroupName,
                searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(),
                serviceParam, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceParam == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceParam is required and cannot be null."));
        } else {
            serviceParam.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId,
            this.client.getApiVersion(), this.client.getSubscriptionId(), serviceParam, accept, context);
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SearchServiceInner>, SearchServiceInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId);
        return this.client.<SearchServiceInner, SearchServiceInner>getLroResult(mono, this.client.getHttpPipeline(),
            SearchServiceInner.class, SearchServiceInner.class, this.client.getContext());
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SearchServiceInner>, SearchServiceInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam) {
        final UUID clientRequestId = null;
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId);
        return this.client.<SearchServiceInner, SearchServiceInner>getLroResult(mono, this.client.getHttpPipeline(),
            SearchServiceInner.class, SearchServiceInner.class, this.client.getContext());
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SearchServiceInner>, SearchServiceInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, searchServiceName,
            serviceParam, clientRequestId, context);
        return this.client.<SearchServiceInner, SearchServiceInner>getLroResult(mono, this.client.getHttpPipeline(),
            SearchServiceInner.class, SearchServiceInner.class, context);
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SearchServiceInner>, SearchServiceInner> beginCreateOrUpdate(String resourceGroupName,
        String searchServiceName, SearchServiceInner serviceParam) {
        final UUID clientRequestId = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId)
            .getSyncPoller();
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SearchServiceInner>, SearchServiceInner> beginCreateOrUpdate(String resourceGroupName,
        String searchServiceName, SearchServiceInner serviceParam, UUID clientRequestId, Context context) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context)
            .getSyncPoller();
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchServiceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName,
        SearchServiceInner serviceParam, UUID clientRequestId) {
        return beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchServiceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName,
        SearchServiceInner serviceParam) {
        final UUID clientRequestId = null;
        return beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SearchServiceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName,
        SearchServiceInner serviceParam, UUID clientRequestId, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchServiceInner createOrUpdate(String resourceGroupName, String searchServiceName,
        SearchServiceInner serviceParam) {
        final UUID clientRequestId = null;
        return createOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).block();
    }

    /**
     * Creates or updates a search service in the given resource group. If the search service already exists, all
     * properties will be updated with the given values.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to create or update. Search service names must
     * only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot
     * contain consecutive dashes, and must be between 2 and 60 characters in length. Search service names must be
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net). You cannot change the
     * service name after the service is created.
     * @param serviceParam The definition of the search service to create or update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchServiceInner createOrUpdate(String resourceGroupName, String searchServiceName,
        SearchServiceInner serviceParam, UUID clientRequestId, Context context) {
        return createOrUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context)
            .block();
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String searchServiceName,
        SearchServiceUpdate serviceParam, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceParam == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceParam is required and cannot be null."));
        } else {
            serviceParam.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), resourceGroupName, searchServiceName,
                clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), serviceParam, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String searchServiceName,
        SearchServiceUpdate serviceParam, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (serviceParam == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceParam is required and cannot be null."));
        } else {
            serviceParam.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId,
            this.client.getApiVersion(), this.client.getSubscriptionId(), serviceParam, accept, context);
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SearchServiceInner>, SearchServiceInner> beginUpdateAsync(String resourceGroupName,
        String searchServiceName, SearchServiceUpdate serviceParam, UUID clientRequestId) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId);
        return this.client.<SearchServiceInner, SearchServiceInner>getLroResult(mono, this.client.getHttpPipeline(),
            SearchServiceInner.class, SearchServiceInner.class, this.client.getContext());
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SearchServiceInner>, SearchServiceInner> beginUpdateAsync(String resourceGroupName,
        String searchServiceName, SearchServiceUpdate serviceParam) {
        final UUID clientRequestId = null;
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId);
        return this.client.<SearchServiceInner, SearchServiceInner>getLroResult(mono, this.client.getHttpPipeline(),
            SearchServiceInner.class, SearchServiceInner.class, this.client.getContext());
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SearchServiceInner>, SearchServiceInner> beginUpdateAsync(String resourceGroupName,
        String searchServiceName, SearchServiceUpdate serviceParam, UUID clientRequestId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context);
        return this.client.<SearchServiceInner, SearchServiceInner>getLroResult(mono, this.client.getHttpPipeline(),
            SearchServiceInner.class, SearchServiceInner.class, context);
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SearchServiceInner>, SearchServiceInner> beginUpdate(String resourceGroupName,
        String searchServiceName, SearchServiceUpdate serviceParam) {
        final UUID clientRequestId = null;
        return this.beginUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId)
            .getSyncPoller();
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SearchServiceInner>, SearchServiceInner> beginUpdate(String resourceGroupName,
        String searchServiceName, SearchServiceUpdate serviceParam, UUID clientRequestId, Context context) {
        return this.beginUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context)
            .getSyncPoller();
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchServiceInner> updateAsync(String resourceGroupName, String searchServiceName,
        SearchServiceUpdate serviceParam, UUID clientRequestId) {
        return beginUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchServiceInner> updateAsync(String resourceGroupName, String searchServiceName,
        SearchServiceUpdate serviceParam) {
        final UUID clientRequestId = null;
        return beginUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SearchServiceInner> updateAsync(String resourceGroupName, String searchServiceName,
        SearchServiceUpdate serviceParam, UUID clientRequestId, Context context) {
        return beginUpdateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchServiceInner update(String resourceGroupName, String searchServiceName,
        SearchServiceUpdate serviceParam) {
        final UUID clientRequestId = null;
        return updateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId).block();
    }

    /**
     * Updates an existing search service in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service to update.
     * @param serviceParam The definition of the search service to update.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchServiceInner update(String resourceGroupName, String searchServiceName,
        SearchServiceUpdate serviceParam, UUID clientRequestId, Context context) {
        return updateAsync(resourceGroupName, searchServiceName, serviceParam, clientRequestId, context).block();
    }

    /**
     * Gets the search service with the given name in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the search service with the given name in the given resource group along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchServiceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String searchServiceName, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, searchServiceName,
                    clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the search service with the given name in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the search service with the given name in the given resource group along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SearchServiceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String searchServiceName, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, searchServiceName,
            clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Gets the search service with the given name in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the search service with the given name in the given resource group on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchServiceInner> getByResourceGroupAsync(String resourceGroupName, String searchServiceName) {
        final UUID clientRequestId = null;
        return getByResourceGroupWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the search service with the given name in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the search service with the given name in the given resource group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchServiceInner> getByResourceGroupWithResponse(String resourceGroupName,
        String searchServiceName, UUID clientRequestId, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId, context)
            .block();
    }

    /**
     * Gets the search service with the given name in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the search service with the given name in the given resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchServiceInner getByResourceGroup(String resourceGroupName, String searchServiceName) {
        final UUID clientRequestId = null;
        return getByResourceGroupWithResponse(resourceGroupName, searchServiceName, clientRequestId, Context.NONE)
            .getValue();
    }

    /**
     * Deletes a search service in the given resource group, along with its associated resources.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String searchServiceName,
        UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), resourceGroupName, searchServiceName,
                clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a search service in the given resource group, along with its associated resources.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String searchServiceName,
        UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId,
            this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Deletes a search service in the given resource group, along with its associated resources.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String searchServiceName) {
        final UUID clientRequestId = null;
        return deleteWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a search service in the given resource group, along with its associated resources.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String searchServiceName, UUID clientRequestId,
        Context context) {
        return deleteWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId, context).block();
    }

    /**
     * Deletes a search service in the given resource group, along with its associated resources.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String searchServiceName) {
        final UUID clientRequestId = null;
        deleteWithResponse(resourceGroupName, searchServiceName, clientRequestId, Context.NONE);
    }

    /**
     * Gets a list of all Search services in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given resource group along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName,
                clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<SearchServiceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of all Search services in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given resource group along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(this.client.getEndpoint(), resourceGroupName, clientRequestId,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets a list of all Search services in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SearchServiceInner> listByResourceGroupAsync(String resourceGroupName, UUID clientRequestId) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, clientRequestId),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, clientRequestId));
    }

    /**
     * Gets a list of all Search services in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SearchServiceInner> listByResourceGroupAsync(String resourceGroupName) {
        final UUID clientRequestId = null;
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, clientRequestId),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, clientRequestId));
    }

    /**
     * Gets a list of all Search services in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SearchServiceInner> listByResourceGroupAsync(String resourceGroupName, UUID clientRequestId,
        Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, clientRequestId, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, clientRequestId, context));
    }

    /**
     * Gets a list of all Search services in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given resource group as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SearchServiceInner> listByResourceGroup(String resourceGroupName) {
        final UUID clientRequestId = null;
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, clientRequestId));
    }

    /**
     * Gets a list of all Search services in the given resource group.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given resource group as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SearchServiceInner> listByResourceGroup(String resourceGroupName, UUID clientRequestId,
        Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, clientRequestId, context));
    }

    /**
     * Gets a list of all Search services in the given subscription.
     * 
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given subscription along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listSinglePageAsync(UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), clientRequestId,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<SearchServiceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of all Search services in the given subscription.
     * 
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given subscription along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listSinglePageAsync(UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), clientRequestId, this.client.getApiVersion(),
                this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets a list of all Search services in the given subscription.
     * 
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SearchServiceInner> listAsync(UUID clientRequestId) {
        return new PagedFlux<>(() -> listSinglePageAsync(clientRequestId),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink, clientRequestId));
    }

    /**
     * Gets a list of all Search services in the given subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SearchServiceInner> listAsync() {
        final UUID clientRequestId = null;
        return new PagedFlux<>(() -> listSinglePageAsync(clientRequestId),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink, clientRequestId));
    }

    /**
     * Gets a list of all Search services in the given subscription.
     * 
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SearchServiceInner> listAsync(UUID clientRequestId, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(clientRequestId, context),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink, clientRequestId, context));
    }

    /**
     * Gets a list of all Search services in the given subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SearchServiceInner> list() {
        final UUID clientRequestId = null;
        return new PagedIterable<>(listAsync(clientRequestId));
    }

    /**
     * Gets a list of all Search services in the given subscription.
     * 
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all Search services in the given subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SearchServiceInner> list(UUID clientRequestId, Context context) {
        return new PagedIterable<>(listAsync(clientRequestId, context));
    }

    /**
     * Checks whether or not the given search service name is available for use. Search service names must be globally
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net).
     * 
     * @param checkNameAvailabilityInput The resource name and type to check.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CheckNameAvailabilityOutput>> checkNameAvailabilityWithResponseAsync(
        CheckNameAvailabilityInput checkNameAvailabilityInput, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (checkNameAvailabilityInput == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter checkNameAvailabilityInput is required and cannot be null."));
        } else {
            checkNameAvailabilityInput.validate();
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.checkNameAvailability(this.client.getEndpoint(), clientRequestId,
            this.client.getApiVersion(), this.client.getSubscriptionId(), checkNameAvailabilityInput, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Checks whether or not the given search service name is available for use. Search service names must be globally
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net).
     * 
     * @param checkNameAvailabilityInput The resource name and type to check.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CheckNameAvailabilityOutput>> checkNameAvailabilityWithResponseAsync(
        CheckNameAvailabilityInput checkNameAvailabilityInput, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (checkNameAvailabilityInput == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter checkNameAvailabilityInput is required and cannot be null."));
        } else {
            checkNameAvailabilityInput.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkNameAvailability(this.client.getEndpoint(), clientRequestId, this.client.getApiVersion(),
            this.client.getSubscriptionId(), checkNameAvailabilityInput, accept, context);
    }

    /**
     * Checks whether or not the given search service name is available for use. Search service names must be globally
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net).
     * 
     * @param checkNameAvailabilityInput The resource name and type to check.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CheckNameAvailabilityOutput>
        checkNameAvailabilityAsync(CheckNameAvailabilityInput checkNameAvailabilityInput) {
        final UUID clientRequestId = null;
        return checkNameAvailabilityWithResponseAsync(checkNameAvailabilityInput, clientRequestId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Checks whether or not the given search service name is available for use. Search service names must be globally
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net).
     * 
     * @param checkNameAvailabilityInput The resource name and type to check.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CheckNameAvailabilityOutput> checkNameAvailabilityWithResponse(
        CheckNameAvailabilityInput checkNameAvailabilityInput, UUID clientRequestId, Context context) {
        return checkNameAvailabilityWithResponseAsync(checkNameAvailabilityInput, clientRequestId, context).block();
    }

    /**
     * Checks whether or not the given search service name is available for use. Search service names must be globally
     * unique since they are part of the service URI (https://&lt;name&gt;.search.windows.net).
     * 
     * @param checkNameAvailabilityInput The resource name and type to check.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CheckNameAvailabilityOutput checkNameAvailability(CheckNameAvailabilityInput checkNameAvailabilityInput) {
        final UUID clientRequestId = null;
        return checkNameAvailabilityWithResponse(checkNameAvailabilityInput, clientRequestId, Context.NONE).getValue();
    }

    /**
     * Upgrades the Azure AI Search service to the latest version available.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> upgradeWithResponseAsync(String resourceGroupName,
        String searchServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.upgrade(this.client.getEndpoint(), resourceGroupName, searchServiceName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Upgrades the Azure AI Search service to the latest version available.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> upgradeWithResponseAsync(String resourceGroupName,
        String searchServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.upgrade(this.client.getEndpoint(), resourceGroupName, searchServiceName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Upgrades the Azure AI Search service to the latest version available.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SearchServiceInner>, SearchServiceInner> beginUpgradeAsync(String resourceGroupName,
        String searchServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = upgradeWithResponseAsync(resourceGroupName, searchServiceName);
        return this.client.<SearchServiceInner, SearchServiceInner>getLroResult(mono, this.client.getHttpPipeline(),
            SearchServiceInner.class, SearchServiceInner.class, this.client.getContext());
    }

    /**
     * Upgrades the Azure AI Search service to the latest version available.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SearchServiceInner>, SearchServiceInner> beginUpgradeAsync(String resourceGroupName,
        String searchServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = upgradeWithResponseAsync(resourceGroupName, searchServiceName, context);
        return this.client.<SearchServiceInner, SearchServiceInner>getLroResult(mono, this.client.getHttpPipeline(),
            SearchServiceInner.class, SearchServiceInner.class, context);
    }

    /**
     * Upgrades the Azure AI Search service to the latest version available.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SearchServiceInner>, SearchServiceInner> beginUpgrade(String resourceGroupName,
        String searchServiceName) {
        return this.beginUpgradeAsync(resourceGroupName, searchServiceName).getSyncPoller();
    }

    /**
     * Upgrades the Azure AI Search service to the latest version available.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SearchServiceInner>, SearchServiceInner> beginUpgrade(String resourceGroupName,
        String searchServiceName, Context context) {
        return this.beginUpgradeAsync(resourceGroupName, searchServiceName, context).getSyncPoller();
    }

    /**
     * Upgrades the Azure AI Search service to the latest version available.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchServiceInner> upgradeAsync(String resourceGroupName, String searchServiceName) {
        return beginUpgradeAsync(resourceGroupName, searchServiceName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Upgrades the Azure AI Search service to the latest version available.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SearchServiceInner> upgradeAsync(String resourceGroupName, String searchServiceName, Context context) {
        return beginUpgradeAsync(resourceGroupName, searchServiceName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Upgrades the Azure AI Search service to the latest version available.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchServiceInner upgrade(String resourceGroupName, String searchServiceName) {
        return upgradeAsync(resourceGroupName, searchServiceName).block();
    }

    /**
     * Upgrades the Azure AI Search service to the latest version available.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes an Azure AI Search service and its current state.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchServiceInner upgrade(String resourceGroupName, String searchServiceName, Context context) {
        return upgradeAsync(resourceGroupName, searchServiceName, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing a list of Azure AI Search services along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listByResourceGroupNextSinglePageAsync(String nextLink,
        UUID clientRequestId) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(),
                clientRequestId, accept, context))
            .<PagedResponse<SearchServiceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing a list of Azure AI Search services along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listByResourceGroupNextSinglePageAsync(String nextLink,
        UUID clientRequestId, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), clientRequestId, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing a list of Azure AI Search services along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listBySubscriptionNextSinglePageAsync(String nextLink,
        UUID clientRequestId) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), clientRequestId,
                accept, context))
            .<PagedResponse<SearchServiceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     * included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing a list of Azure AI Search services along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SearchServiceInner>> listBySubscriptionNextSinglePageAsync(String nextLink,
        UUID clientRequestId, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), clientRequestId, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
