// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Access rule in a network security perimeter configuration profile.
 */
@Fluent
public final class AccessRule implements JsonSerializable<AccessRule> {
    /*
     * Name of the access rule
     */
    private String name;

    /*
     * Properties of Access Rule
     */
    private AccessRuleProperties properties;

    /**
     * Creates an instance of AccessRule class.
     */
    public AccessRule() {
    }

    /**
     * Get the name property: Name of the access rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the access rule.
     * 
     * @param name the name value to set.
     * @return the AccessRule object itself.
     */
    public AccessRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the properties property: Properties of Access Rule.
     * 
     * @return the properties value.
     */
    public AccessRuleProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of Access Rule.
     * 
     * @param properties the properties value to set.
     * @return the AccessRule object itself.
     */
    public AccessRule withProperties(AccessRuleProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessRule if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the AccessRule.
     */
    public static AccessRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessRule deserializedAccessRule = new AccessRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAccessRule.name = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedAccessRule.properties = AccessRuleProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessRule;
        });
    }
}
