// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the options for how the search service authenticates a data plane request. This cannot be set if
 * 'disableLocalAuth' is set to true.
 */
@Fluent
public final class DataPlaneAuthOptions implements JsonSerializable<DataPlaneAuthOptions> {
    /*
     * Indicates that only the API key can be used for authentication.
     */
    private Object apiKeyOnly;

    /*
     * Indicates that either the API key or an access token from a Microsoft Entra ID tenant can be used for
     * authentication.
     */
    private DataPlaneAadOrApiKeyAuthOption aadOrApiKey;

    /**
     * Creates an instance of DataPlaneAuthOptions class.
     */
    public DataPlaneAuthOptions() {
    }

    /**
     * Get the apiKeyOnly property: Indicates that only the API key can be used for authentication.
     * 
     * @return the apiKeyOnly value.
     */
    public Object apiKeyOnly() {
        return this.apiKeyOnly;
    }

    /**
     * Set the apiKeyOnly property: Indicates that only the API key can be used for authentication.
     * 
     * @param apiKeyOnly the apiKeyOnly value to set.
     * @return the DataPlaneAuthOptions object itself.
     */
    public DataPlaneAuthOptions withApiKeyOnly(Object apiKeyOnly) {
        this.apiKeyOnly = apiKeyOnly;
        return this;
    }

    /**
     * Get the aadOrApiKey property: Indicates that either the API key or an access token from a Microsoft Entra ID
     * tenant can be used for authentication.
     * 
     * @return the aadOrApiKey value.
     */
    public DataPlaneAadOrApiKeyAuthOption aadOrApiKey() {
        return this.aadOrApiKey;
    }

    /**
     * Set the aadOrApiKey property: Indicates that either the API key or an access token from a Microsoft Entra ID
     * tenant can be used for authentication.
     * 
     * @param aadOrApiKey the aadOrApiKey value to set.
     * @return the DataPlaneAuthOptions object itself.
     */
    public DataPlaneAuthOptions withAadOrApiKey(DataPlaneAadOrApiKeyAuthOption aadOrApiKey) {
        this.aadOrApiKey = aadOrApiKey;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (aadOrApiKey() != null) {
            aadOrApiKey().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.apiKeyOnly != null) {
            jsonWriter.writeUntypedField("apiKeyOnly", this.apiKeyOnly);
        }
        jsonWriter.writeJsonField("aadOrApiKey", this.aadOrApiKey);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataPlaneAuthOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataPlaneAuthOptions if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataPlaneAuthOptions.
     */
    public static DataPlaneAuthOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataPlaneAuthOptions deserializedDataPlaneAuthOptions = new DataPlaneAuthOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("apiKeyOnly".equals(fieldName)) {
                    deserializedDataPlaneAuthOptions.apiKeyOnly = reader.readUntyped();
                } else if ("aadOrApiKey".equals(fieldName)) {
                    deserializedDataPlaneAuthOptions.aadOrApiKey = DataPlaneAadOrApiKeyAuthOption.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataPlaneAuthOptions;
        });
    }
}
