// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a policy that determines how resources within the search service are to be encrypted with customer managed
 * keys.
 */
@Fluent
public final class EncryptionWithCmk implements JsonSerializable<EncryptionWithCmk> {
    /*
     * Describes how a search service should enforce compliance if it finds objects that aren't encrypted with the
     * customer-managed key.
     */
    private SearchEncryptionWithCmk enforcement;

    /*
     * Returns the status of search service compliance with respect to non-CMK-encrypted objects. If a service has more
     * than one unencrypted object, and enforcement is enabled, the service is marked as noncompliant.
     */
    private SearchEncryptionComplianceStatus encryptionComplianceStatus;

    /**
     * Creates an instance of EncryptionWithCmk class.
     */
    public EncryptionWithCmk() {
    }

    /**
     * Get the enforcement property: Describes how a search service should enforce compliance if it finds objects that
     * aren't encrypted with the customer-managed key.
     * 
     * @return the enforcement value.
     */
    public SearchEncryptionWithCmk enforcement() {
        return this.enforcement;
    }

    /**
     * Set the enforcement property: Describes how a search service should enforce compliance if it finds objects that
     * aren't encrypted with the customer-managed key.
     * 
     * @param enforcement the enforcement value to set.
     * @return the EncryptionWithCmk object itself.
     */
    public EncryptionWithCmk withEnforcement(SearchEncryptionWithCmk enforcement) {
        this.enforcement = enforcement;
        return this;
    }

    /**
     * Get the encryptionComplianceStatus property: Returns the status of search service compliance with respect to
     * non-CMK-encrypted objects. If a service has more than one unencrypted object, and enforcement is enabled, the
     * service is marked as noncompliant.
     * 
     * @return the encryptionComplianceStatus value.
     */
    public SearchEncryptionComplianceStatus encryptionComplianceStatus() {
        return this.encryptionComplianceStatus;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("enforcement", this.enforcement == null ? null : this.enforcement.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionWithCmk from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionWithCmk if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EncryptionWithCmk.
     */
    public static EncryptionWithCmk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionWithCmk deserializedEncryptionWithCmk = new EncryptionWithCmk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enforcement".equals(fieldName)) {
                    deserializedEncryptionWithCmk.enforcement = SearchEncryptionWithCmk.fromString(reader.getString());
                } else if ("encryptionComplianceStatus".equals(fieldName)) {
                    deserializedEncryptionWithCmk.encryptionComplianceStatus
                        = SearchEncryptionComplianceStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionWithCmk;
        });
    }
}
