// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Details about the search service identity. A null value indicates that the search service has no identity assigned.
 */
@Fluent
public final class Identity implements JsonSerializable<Identity> {
    /*
     * The principal ID of the system-assigned identity of the search service.
     */
    private String principalId;

    /*
     * The tenant ID of the system-assigned identity of the search service.
     */
    private String tenantId;

    /*
     * The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an identity
     * created by the system and a set of user assigned identities. The type 'None' will remove all identities from the
     * service.
     */
    private IdentityType type;

    /*
     * The list of user identities associated with the resource. The user identity dictionary key references will be ARM
     * resource IDs in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/
     * userAssignedIdentities/{identityName}'.
     */
    private Map<String, UserAssignedIdentity> userAssignedIdentities;

    /**
     * Creates an instance of Identity class.
     */
    public Identity() {
    }

    /**
     * Get the principalId property: The principal ID of the system-assigned identity of the search service.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Get the tenantId property: The tenant ID of the system-assigned identity of the search service.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the type property: The type of identity used for the resource. The type 'SystemAssigned, UserAssigned'
     * includes both an identity created by the system and a set of user assigned identities. The type 'None' will
     * remove all identities from the service.
     * 
     * @return the type value.
     */
    public IdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of identity used for the resource. The type 'SystemAssigned, UserAssigned'
     * includes both an identity created by the system and a set of user assigned identities. The type 'None' will
     * remove all identities from the service.
     * 
     * @param type the type value to set.
     * @return the Identity object itself.
     */
    public Identity withType(IdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the userAssignedIdentities property: The list of user identities associated with the resource. The user
     * identity dictionary key references will be ARM resource IDs in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * 
     * @return the userAssignedIdentities value.
     */
    public Map<String, UserAssignedIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    /**
     * Set the userAssignedIdentities property: The list of user identities associated with the resource. The user
     * identity dictionary key references will be ARM resource IDs in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * 
     * @param userAssignedIdentities the userAssignedIdentities value to set.
     * @return the Identity object itself.
     */
    public Identity withUserAssignedIdentities(Map<String, UserAssignedIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model Identity"));
        }
        if (userAssignedIdentities() != null) {
            userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Identity.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Identity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Identity if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Identity.
     */
    public static Identity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Identity deserializedIdentity = new Identity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedIdentity.type = IdentityType.fromString(reader.getString());
                } else if ("principalId".equals(fieldName)) {
                    deserializedIdentity.principalId = reader.getString();
                } else if ("tenantId".equals(fieldName)) {
                    deserializedIdentity.tenantId = reader.getString();
                } else if ("userAssignedIdentities".equals(fieldName)) {
                    Map<String, UserAssignedIdentity> userAssignedIdentities
                        = reader.readMap(reader1 -> UserAssignedIdentity.fromJson(reader1));
                    deserializedIdentity.userAssignedIdentities = userAssignedIdentities;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIdentity;
        });
    }
}
