// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

/**
 * The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an identity created
 * by the system and a set of user assigned identities. The type 'None' will remove all identities from the service.
 */
public enum IdentityType {
    /**
     * Enum value None.
     */
    NONE("None"),

    /**
     * Enum value SystemAssigned.
     */
    SYSTEM_ASSIGNED("SystemAssigned"),

    /**
     * Enum value UserAssigned.
     */
    USER_ASSIGNED("UserAssigned"),

    /**
     * Enum value SystemAssigned, UserAssigned.
     */
    SYSTEM_ASSIGNED_USER_ASSIGNED("SystemAssigned, UserAssigned");

    /**
     * The actual serialized value for a IdentityType instance.
     */
    private final String value;

    IdentityType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a IdentityType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed IdentityType object, or null if unable to parse.
     */
    public static IdentityType fromString(String value) {
        if (value == null) {
            return null;
        }
        IdentityType[] items = IdentityType.values();
        for (IdentityType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
