// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of issue.
 */
public final class IssueType extends ExpandableStringEnum<IssueType> {
    /**
     * Static value Unknown for IssueType.
     */
    public static final IssueType UNKNOWN = fromString("Unknown");

    /**
     * Static value ConfigurationPropagationFailure for IssueType.
     */
    public static final IssueType CONFIGURATION_PROPAGATION_FAILURE = fromString("ConfigurationPropagationFailure");

    /**
     * Static value MissingPerimeterConfiguration for IssueType.
     */
    public static final IssueType MISSING_PERIMETER_CONFIGURATION = fromString("MissingPerimeterConfiguration");

    /**
     * Static value MissingIdentityConfiguration for IssueType.
     */
    public static final IssueType MISSING_IDENTITY_CONFIGURATION = fromString("MissingIdentityConfiguration");

    /**
     * Creates a new instance of IssueType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IssueType() {
    }

    /**
     * Creates or finds a IssueType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IssueType.
     */
    public static IssueType fromString(String name) {
        return fromString(name, IssueType.class);
    }

    /**
     * Gets known IssueType values.
     * 
     * @return known IssueType values.
     */
    public static Collection<IssueType> values() {
        return values(IssueType.class);
    }
}
