// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Details of a provisioning issue for a network security perimeter (NSP) configuration. Resource providers should
 * generate separate provisioning issue elements for each separate issue detected, and include a meaningful and
 * distinctive description, as well as any appropriate suggestedResourceIds and suggestedAccessRules.
 */
@Immutable
public final class ProvisioningIssueProperties implements JsonSerializable<ProvisioningIssueProperties> {
    /*
     * Type of issue
     */
    private IssueType issueType;

    /*
     * Severity of the issue.
     */
    private Severity severity;

    /*
     * Description of the issue
     */
    private String description;

    /*
     * Fully qualified resource IDs of suggested resources that can be associated to the network security perimeter
     * (NSP) to remediate the issue.
     */
    private List<String> suggestedResourceIds;

    /*
     * Access rules that can be added to the network security profile (NSP) to remediate the issue.
     */
    private List<AccessRule> suggestedAccessRules;

    /**
     * Creates an instance of ProvisioningIssueProperties class.
     */
    public ProvisioningIssueProperties() {
    }

    /**
     * Get the issueType property: Type of issue.
     * 
     * @return the issueType value.
     */
    public IssueType issueType() {
        return this.issueType;
    }

    /**
     * Get the severity property: Severity of the issue.
     * 
     * @return the severity value.
     */
    public Severity severity() {
        return this.severity;
    }

    /**
     * Get the description property: Description of the issue.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the suggestedResourceIds property: Fully qualified resource IDs of suggested resources that can be associated
     * to the network security perimeter (NSP) to remediate the issue.
     * 
     * @return the suggestedResourceIds value.
     */
    public List<String> suggestedResourceIds() {
        return this.suggestedResourceIds;
    }

    /**
     * Get the suggestedAccessRules property: Access rules that can be added to the network security profile (NSP) to
     * remediate the issue.
     * 
     * @return the suggestedAccessRules value.
     */
    public List<AccessRule> suggestedAccessRules() {
        return this.suggestedAccessRules;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (suggestedAccessRules() != null) {
            suggestedAccessRules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProvisioningIssueProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProvisioningIssueProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProvisioningIssueProperties.
     */
    public static ProvisioningIssueProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProvisioningIssueProperties deserializedProvisioningIssueProperties = new ProvisioningIssueProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("issueType".equals(fieldName)) {
                    deserializedProvisioningIssueProperties.issueType = IssueType.fromString(reader.getString());
                } else if ("severity".equals(fieldName)) {
                    deserializedProvisioningIssueProperties.severity = Severity.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedProvisioningIssueProperties.description = reader.getString();
                } else if ("suggestedResourceIds".equals(fieldName)) {
                    List<String> suggestedResourceIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedProvisioningIssueProperties.suggestedResourceIds = suggestedResourceIds;
                } else if ("suggestedAccessRules".equals(fieldName)) {
                    List<AccessRule> suggestedAccessRules = reader.readArray(reader1 -> AccessRule.fromJson(reader1));
                    deserializedProvisioningIssueProperties.suggestedAccessRules = suggestedAccessRules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProvisioningIssueProperties;
        });
    }
}
