// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about resource association.
 */
@Fluent
public final class ResourceAssociation implements JsonSerializable<ResourceAssociation> {
    /*
     * Name of the resource association
     */
    private String name;

    /*
     * Access mode of the resource association
     */
    private ResourceAssociationAccessMode accessMode;

    /**
     * Creates an instance of ResourceAssociation class.
     */
    public ResourceAssociation() {
    }

    /**
     * Get the name property: Name of the resource association.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the resource association.
     * 
     * @param name the name value to set.
     * @return the ResourceAssociation object itself.
     */
    public ResourceAssociation withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the accessMode property: Access mode of the resource association.
     * 
     * @return the accessMode value.
     */
    public ResourceAssociationAccessMode accessMode() {
        return this.accessMode;
    }

    /**
     * Set the accessMode property: Access mode of the resource association.
     * 
     * @param accessMode the accessMode value to set.
     * @return the ResourceAssociation object itself.
     */
    public ResourceAssociation withAccessMode(ResourceAssociationAccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("accessMode", this.accessMode == null ? null : this.accessMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceAssociation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceAssociation if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceAssociation.
     */
    public static ResourceAssociation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceAssociation deserializedResourceAssociation = new ResourceAssociation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedResourceAssociation.name = reader.getString();
                } else if ("accessMode".equals(fieldName)) {
                    deserializedResourceAssociation.accessMode
                        = ResourceAssociationAccessMode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceAssociation;
        });
    }
}
