// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

/**
 * The SKU of the search service. Valid values include: 'free': Shared service. 'basic': Dedicated service with up to 3
 * replicas. 'standard': Dedicated service with up to 12 partitions and 12 replicas. 'standard2': Similar to standard,
 * but with more capacity per search unit. 'standard3': The largest Standard offering with up to 12 partitions and 12
 * replicas (or up to 3 partitions with more indexes if you also set the hostingMode property to 'highDensity').
 * 'storage_optimized_l1': Supports 1TB per partition, up to 12 partitions. 'storage_optimized_l2': Supports 2TB per
 * partition, up to 12 partitions.'.
 */
public enum SkuName {
    /**
     * Enum value free.
     */
    FREE("free"),

    /**
     * Enum value basic.
     */
    BASIC("basic"),

    /**
     * Enum value standard.
     */
    STANDARD("standard"),

    /**
     * Enum value standard2.
     */
    STANDARD2("standard2"),

    /**
     * Enum value standard3.
     */
    STANDARD3("standard3"),

    /**
     * Enum value storage_optimized_l1.
     */
    STORAGE_OPTIMIZED_L1("storage_optimized_l1"),

    /**
     * Enum value storage_optimized_l2.
     */
    STORAGE_OPTIMIZED_L2("storage_optimized_l2");

    /**
     * The actual serialized value for a SkuName instance.
     */
    private final String value;

    SkuName(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a SkuName instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed SkuName object, or null if unable to parse.
     */
    public static SkuName fromString(String value) {
        if (value == null) {
            return null;
        }
        SkuName[] items = SkuName.values();
        for (SkuName item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
