// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Indicates if the search service has an upgrade available.
 */
public final class UpgradeAvailable extends ExpandableStringEnum<UpgradeAvailable> {
    /**
     * Static value notAvailable for UpgradeAvailable.
     */
    public static final UpgradeAvailable NOT_AVAILABLE = fromString("notAvailable");

    /**
     * Static value available for UpgradeAvailable.
     */
    public static final UpgradeAvailable AVAILABLE = fromString("available");

    /**
     * Creates a new instance of UpgradeAvailable value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public UpgradeAvailable() {
    }

    /**
     * Creates or finds a UpgradeAvailable from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding UpgradeAvailable.
     */
    public static UpgradeAvailable fromString(String name) {
        return fromString(name, UpgradeAvailable.class);
    }

    /**
     * Gets known UpgradeAvailable values.
     * 
     * @return known UpgradeAvailable values.
     */
    public static Collection<UpgradeAvailable> values() {
        return values(UpgradeAvailable.class);
    }
}
