/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.search.fluent.NetworkSecurityPerimeterConfigurationsClient;
import com.azure.resourcemanager.search.fluent.models.NetworkSecurityPerimeterConfigurationInner;
import com.azure.resourcemanager.search.implementation.SearchManagementClientImpl;
import com.azure.resourcemanager.search.models.NetworkSecurityPerimeterConfigurationListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class NetworkSecurityPerimeterConfigurationsClientImpl
implements NetworkSecurityPerimeterConfigurationsClient {
    private final NetworkSecurityPerimeterConfigurationsService service;
    private final SearchManagementClientImpl client;

    NetworkSecurityPerimeterConfigurationsClientImpl(SearchManagementClientImpl client) {
        this.service = (NetworkSecurityPerimeterConfigurationsService)RestProxy.create(NetworkSecurityPerimeterConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterConfigurationInner>> listByServiceSinglePageAsync(String resourceGroupName, String searchServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByService(this.client.getEndpoint(), resourceGroupName, searchServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterConfigurationListResult)res.getValue()).value(), ((NetworkSecurityPerimeterConfigurationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterConfigurationInner>> listByServiceSinglePageAsync(String resourceGroupName, String searchServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByService(this.client.getEndpoint(), resourceGroupName, searchServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterConfigurationListResult)res.getValue()).value(), ((NetworkSecurityPerimeterConfigurationListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NetworkSecurityPerimeterConfigurationInner> listByServiceAsync(String resourceGroupName, String searchServiceName) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, searchServiceName), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NetworkSecurityPerimeterConfigurationInner> listByServiceAsync(String resourceGroupName, String searchServiceName, Context context) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, searchServiceName, context), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkSecurityPerimeterConfigurationInner> listByService(String resourceGroupName, String searchServiceName) {
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, searchServiceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkSecurityPerimeterConfigurationInner> listByService(String resourceGroupName, String searchServiceName, Context context) {
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, searchServiceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NetworkSecurityPerimeterConfigurationInner>> getWithResponseAsync(String resourceGroupName, String searchServiceName, String nspConfigName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (nspConfigName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nspConfigName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, searchServiceName, nspConfigName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkSecurityPerimeterConfigurationInner>> getWithResponseAsync(String resourceGroupName, String searchServiceName, String nspConfigName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (nspConfigName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nspConfigName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, searchServiceName, nspConfigName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NetworkSecurityPerimeterConfigurationInner> getAsync(String resourceGroupName, String searchServiceName, String nspConfigName) {
        return this.getWithResponseAsync(resourceGroupName, searchServiceName, nspConfigName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NetworkSecurityPerimeterConfigurationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NetworkSecurityPerimeterConfigurationInner> getWithResponse(String resourceGroupName, String searchServiceName, String nspConfigName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, searchServiceName, nspConfigName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkSecurityPerimeterConfigurationInner get(String resourceGroupName, String searchServiceName, String nspConfigName) {
        return (NetworkSecurityPerimeterConfigurationInner)((Object)this.getWithResponse(resourceGroupName, searchServiceName, nspConfigName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> reconcileWithResponseAsync(String resourceGroupName, String searchServiceName, String nspConfigName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (nspConfigName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nspConfigName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.reconcile(this.client.getEndpoint(), resourceGroupName, searchServiceName, nspConfigName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> reconcileWithResponseAsync(String resourceGroupName, String searchServiceName, String nspConfigName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (nspConfigName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nspConfigName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.reconcile(this.client.getEndpoint(), resourceGroupName, searchServiceName, nspConfigName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginReconcileAsync(String resourceGroupName, String searchServiceName, String nspConfigName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reconcileWithResponseAsync(resourceGroupName, searchServiceName, nspConfigName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginReconcileAsync(String resourceGroupName, String searchServiceName, String nspConfigName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.reconcileWithResponseAsync(resourceGroupName, searchServiceName, nspConfigName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReconcile(String resourceGroupName, String searchServiceName, String nspConfigName) {
        return this.beginReconcileAsync(resourceGroupName, searchServiceName, nspConfigName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReconcile(String resourceGroupName, String searchServiceName, String nspConfigName, Context context) {
        return this.beginReconcileAsync(resourceGroupName, searchServiceName, nspConfigName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reconcileAsync(String resourceGroupName, String searchServiceName, String nspConfigName) {
        return this.beginReconcileAsync(resourceGroupName, searchServiceName, nspConfigName).last().flatMap(arg_0 -> ((SearchManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> reconcileAsync(String resourceGroupName, String searchServiceName, String nspConfigName, Context context) {
        return this.beginReconcileAsync(resourceGroupName, searchServiceName, nspConfigName, context).last().flatMap(arg_0 -> ((SearchManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reconcile(String resourceGroupName, String searchServiceName, String nspConfigName) {
        this.reconcileAsync(resourceGroupName, searchServiceName, nspConfigName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reconcile(String resourceGroupName, String searchServiceName, String nspConfigName, Context context) {
        this.reconcileAsync(resourceGroupName, searchServiceName, nspConfigName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterConfigurationInner>> listByServiceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServiceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterConfigurationListResult)res.getValue()).value(), ((NetworkSecurityPerimeterConfigurationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterConfigurationInner>> listByServiceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServiceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterConfigurationListResult)res.getValue()).value(), ((NetworkSecurityPerimeterConfigurationListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SearchManagementClientNetworkSecurityPerimeterConfigurations")
    public static interface NetworkSecurityPerimeterConfigurationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/networkSecurityPerimeterConfigurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterConfigurationListResult>> listByService(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/networkSecurityPerimeterConfigurations/{nspConfigName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterConfigurationInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @PathParam(value="nspConfigName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/networkSecurityPerimeterConfigurations/{nspConfigName}/reconcile")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> reconcile(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @PathParam(value="nspConfigName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterConfigurationListResult>> listByServiceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

