/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.models.AccessRuleDirection;
import com.azure.resourcemanager.search.models.AccessRulePropertiesSubscriptionsItem;
import com.azure.resourcemanager.search.models.NetworkSecurityPerimeter;
import java.io.IOException;
import java.util.List;

public final class AccessRuleProperties
implements JsonSerializable<AccessRuleProperties> {
    private AccessRuleDirection direction;
    private List<String> addressPrefixes;
    private List<AccessRulePropertiesSubscriptionsItem> subscriptions;
    private List<NetworkSecurityPerimeter> networkSecurityPerimeters;
    private List<String> fullyQualifiedDomainNames;
    private List<String> emailAddresses;
    private List<String> phoneNumbers;

    public AccessRuleDirection direction() {
        return this.direction;
    }

    public AccessRuleProperties withDirection(AccessRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public AccessRuleProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    public List<AccessRulePropertiesSubscriptionsItem> subscriptions() {
        return this.subscriptions;
    }

    public AccessRuleProperties withSubscriptions(List<AccessRulePropertiesSubscriptionsItem> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public List<NetworkSecurityPerimeter> networkSecurityPerimeters() {
        return this.networkSecurityPerimeters;
    }

    public AccessRuleProperties withNetworkSecurityPerimeters(List<NetworkSecurityPerimeter> networkSecurityPerimeters) {
        this.networkSecurityPerimeters = networkSecurityPerimeters;
        return this;
    }

    public List<String> fullyQualifiedDomainNames() {
        return this.fullyQualifiedDomainNames;
    }

    public AccessRuleProperties withFullyQualifiedDomainNames(List<String> fullyQualifiedDomainNames) {
        this.fullyQualifiedDomainNames = fullyQualifiedDomainNames;
        return this;
    }

    public List<String> emailAddresses() {
        return this.emailAddresses;
    }

    public AccessRuleProperties withEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    public List<String> phoneNumbers() {
        return this.phoneNumbers;
    }

    public AccessRuleProperties withPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    public void validate() {
        if (this.subscriptions() != null) {
            this.subscriptions().forEach(e -> e.validate());
        }
        if (this.networkSecurityPerimeters() != null) {
            this.networkSecurityPerimeters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("subscriptions", this.subscriptions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("networkSecurityPerimeters", this.networkSecurityPerimeters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("fullyQualifiedDomainNames", this.fullyQualifiedDomainNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("emailAddresses", this.emailAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("phoneNumbers", this.phoneNumbers, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AccessRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AccessRuleProperties)jsonReader.readObject(reader -> {
            AccessRuleProperties deserializedAccessRuleProperties = new AccessRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("direction".equals(fieldName)) {
                    deserializedAccessRuleProperties.direction = AccessRuleDirection.fromString(reader.getString());
                    continue;
                }
                if ("addressPrefixes".equals(fieldName)) {
                    List addressPrefixes;
                    deserializedAccessRuleProperties.addressPrefixes = addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("subscriptions".equals(fieldName)) {
                    List subscriptions;
                    deserializedAccessRuleProperties.subscriptions = subscriptions = reader.readArray(reader1 -> AccessRulePropertiesSubscriptionsItem.fromJson(reader1));
                    continue;
                }
                if ("networkSecurityPerimeters".equals(fieldName)) {
                    List networkSecurityPerimeters;
                    deserializedAccessRuleProperties.networkSecurityPerimeters = networkSecurityPerimeters = reader.readArray(reader1 -> NetworkSecurityPerimeter.fromJson(reader1));
                    continue;
                }
                if ("fullyQualifiedDomainNames".equals(fieldName)) {
                    List fullyQualifiedDomainNames;
                    deserializedAccessRuleProperties.fullyQualifiedDomainNames = fullyQualifiedDomainNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("emailAddresses".equals(fieldName)) {
                    List emailAddresses;
                    deserializedAccessRuleProperties.emailAddresses = emailAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("phoneNumbers".equals(fieldName)) {
                    List phoneNumbers;
                    deserializedAccessRuleProperties.phoneNumbers = phoneNumbers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccessRuleProperties;
        });
    }
}

