/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.models.IpRule;
import com.azure.resourcemanager.search.models.SearchBypass;
import java.io.IOException;
import java.util.List;

public final class NetworkRuleSet
implements JsonSerializable<NetworkRuleSet> {
    private List<IpRule> ipRules;
    private SearchBypass bypass;

    public List<IpRule> ipRules() {
        return this.ipRules;
    }

    public NetworkRuleSet withIpRules(List<IpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public SearchBypass bypass() {
        return this.bypass;
    }

    public NetworkRuleSet withBypass(SearchBypass bypass) {
        this.bypass = bypass;
        return this;
    }

    public void validate() {
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("bypass", this.bypass == null ? null : this.bypass.toString());
        return jsonWriter.writeEndObject();
    }

    public static NetworkRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkRuleSet)jsonReader.readObject(reader -> {
            NetworkRuleSet deserializedNetworkRuleSet = new NetworkRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipRules".equals(fieldName)) {
                    List ipRules;
                    deserializedNetworkRuleSet.ipRules = ipRules = reader.readArray(reader1 -> IpRule.fromJson(reader1));
                    continue;
                }
                if ("bypass".equals(fieldName)) {
                    deserializedNetworkRuleSet.bypass = SearchBypass.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkRuleSet;
        });
    }
}

