// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.azure.resourcemanager.search.fluent.AdminKeysClient;
import com.azure.resourcemanager.search.fluent.OperationsClient;
import com.azure.resourcemanager.search.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.search.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.search.fluent.QueryKeysClient;
import com.azure.resourcemanager.search.fluent.SearchManagementClient;
import com.azure.resourcemanager.search.fluent.ServicesClient;
import com.azure.resourcemanager.search.fluent.SharedPrivateLinkResourcesClient;
import java.time.Duration;

/** Initializes a new instance of the SearchManagementClientImpl type. */
@ServiceClient(builder = SearchManagementClientBuilder.class)
public final class SearchManagementClientImpl extends AzureServiceClient implements SearchManagementClient {
    private final ClientLogger logger = new ClientLogger(SearchManagementClientImpl.class);

    /**
     * The unique identifier for a Microsoft Azure subscription. You can obtain this value from the Azure Resource
     * Manager API or the portal.
     */
    private final String subscriptionId;

    /**
     * Gets The unique identifier for a Microsoft Azure subscription. You can obtain this value from the Azure Resource
     * Manager API or the portal.
     *
     * @return the subscriptionId value.
     */
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    /** server parameter. */
    private final String endpoint;

    /**
     * Gets server parameter.
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /** Api Version. */
    private final String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /** The default poll interval for long-running operation. */
    private final Duration defaultPollInterval;

    /**
     * Gets The default poll interval for long-running operation.
     *
     * @return the defaultPollInterval value.
     */
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    /** The OperationsClient object to access its operations. */
    private final OperationsClient operations;

    /**
     * Gets the OperationsClient object to access its operations.
     *
     * @return the OperationsClient object.
     */
    public OperationsClient getOperations() {
        return this.operations;
    }

    /** The AdminKeysClient object to access its operations. */
    private final AdminKeysClient adminKeys;

    /**
     * Gets the AdminKeysClient object to access its operations.
     *
     * @return the AdminKeysClient object.
     */
    public AdminKeysClient getAdminKeys() {
        return this.adminKeys;
    }

    /** The QueryKeysClient object to access its operations. */
    private final QueryKeysClient queryKeys;

    /**
     * Gets the QueryKeysClient object to access its operations.
     *
     * @return the QueryKeysClient object.
     */
    public QueryKeysClient getQueryKeys() {
        return this.queryKeys;
    }

    /** The ServicesClient object to access its operations. */
    private final ServicesClient services;

    /**
     * Gets the ServicesClient object to access its operations.
     *
     * @return the ServicesClient object.
     */
    public ServicesClient getServices() {
        return this.services;
    }

    /** The PrivateLinkResourcesClient object to access its operations. */
    private final PrivateLinkResourcesClient privateLinkResources;

    /**
     * Gets the PrivateLinkResourcesClient object to access its operations.
     *
     * @return the PrivateLinkResourcesClient object.
     */
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    /** The PrivateEndpointConnectionsClient object to access its operations. */
    private final PrivateEndpointConnectionsClient privateEndpointConnections;

    /**
     * Gets the PrivateEndpointConnectionsClient object to access its operations.
     *
     * @return the PrivateEndpointConnectionsClient object.
     */
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /** The SharedPrivateLinkResourcesClient object to access its operations. */
    private final SharedPrivateLinkResourcesClient sharedPrivateLinkResources;

    /**
     * Gets the SharedPrivateLinkResourcesClient object to access its operations.
     *
     * @return the SharedPrivateLinkResourcesClient object.
     */
    public SharedPrivateLinkResourcesClient getSharedPrivateLinkResources() {
        return this.sharedPrivateLinkResources;
    }

    /**
     * Initializes an instance of SearchManagementClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param defaultPollInterval The default poll interval for long-running operation.
     * @param environment The Azure environment.
     * @param subscriptionId The unique identifier for a Microsoft Azure subscription. You can obtain this value from
     *     the Azure Resource Manager API or the portal.
     * @param endpoint server parameter.
     */
    SearchManagementClientImpl(
        HttpPipeline httpPipeline,
        SerializerAdapter serializerAdapter,
        Duration defaultPollInterval,
        AzureEnvironment environment,
        String subscriptionId,
        String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2020-08-01";
        this.operations = new OperationsClientImpl(this);
        this.adminKeys = new AdminKeysClientImpl(this);
        this.queryKeys = new QueryKeysClientImpl(this);
        this.services = new ServicesClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.sharedPrivateLinkResources = new SharedPrivateLinkResourcesClientImpl(this);
    }
}
