// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for UnavailableNameReason. */
public final class UnavailableNameReason extends ExpandableStringEnum<UnavailableNameReason> {
    /** Static value Invalid for UnavailableNameReason. */
    public static final UnavailableNameReason INVALID = fromString("Invalid");

    /** Static value AlreadyExists for UnavailableNameReason. */
    public static final UnavailableNameReason ALREADY_EXISTS = fromString("AlreadyExists");

    /**
     * Creates or finds a UnavailableNameReason from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding UnavailableNameReason.
     */
    @JsonCreator
    public static UnavailableNameReason fromString(String name) {
        return fromString(name, UnavailableNameReason.class);
    }

    /** @return known UnavailableNameReason values. */
    public static Collection<UnavailableNameReason> values() {
        return values(UnavailableNameReason.class);
    }
}
