// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.servicebus.fluent.models.QueueResourceInner;
import com.azure.resourcemanager.servicebus.fluent.models.ResourceListKeysInner;
import com.azure.resourcemanager.servicebus.fluent.models.SharedAccessAuthorizationRuleResourceInner;
import com.azure.resourcemanager.servicebus.models.Policykey;
import com.azure.resourcemanager.servicebus.models.QueueCreateOrUpdateParameters;
import com.azure.resourcemanager.servicebus.models.SharedAccessAuthorizationRuleCreateOrUpdateParameters;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in QueuesClient. */
public interface QueuesClient {
    /**
     * Gets the queues within a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the queues within a namespace.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<QueueResourceInner> listAllAsync(String resourceGroupName, String namespaceName);

    /**
     * Gets the queues within a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the queues within a namespace.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<QueueResourceInner> listAll(String resourceGroupName, String namespaceName);

    /**
     * Gets the queues within a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the queues within a namespace.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<QueueResourceInner> listAll(String resourceGroupName, String namespaceName, Context context);

    /**
     * Creates or updates a Service Bus queue. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param parameters Parameters supplied to the Create Or Update Queue operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of queue Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<QueueResourceInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String namespaceName, String queueName, QueueCreateOrUpdateParameters parameters);

    /**
     * Creates or updates a Service Bus queue. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param parameters Parameters supplied to the Create Or Update Queue operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of queue Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<QueueResourceInner> createOrUpdateAsync(
        String resourceGroupName, String namespaceName, String queueName, QueueCreateOrUpdateParameters parameters);

    /**
     * Creates or updates a Service Bus queue. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param parameters Parameters supplied to the Create Or Update Queue operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of queue Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    QueueResourceInner createOrUpdate(
        String resourceGroupName, String namespaceName, String queueName, QueueCreateOrUpdateParameters parameters);

    /**
     * Creates or updates a Service Bus queue. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param parameters Parameters supplied to the Create Or Update Queue operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of queue Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<QueueResourceInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        QueueCreateOrUpdateParameters parameters,
        Context context);

    /**
     * Deletes a queue from the specified namespace in a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String queueName);

    /**
     * Deletes a queue from the specified namespace in a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String queueName);

    /**
     * Deletes a queue from the specified namespace in a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String namespaceName, String queueName);

    /**
     * Deletes a queue from the specified namespace in a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(
        String resourceGroupName, String namespaceName, String queueName, Context context);

    /**
     * Returns a description for the specified queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of queue Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<QueueResourceInner>> getWithResponseAsync(
        String resourceGroupName, String namespaceName, String queueName);

    /**
     * Returns a description for the specified queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of queue Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<QueueResourceInner> getAsync(String resourceGroupName, String namespaceName, String queueName);

    /**
     * Returns a description for the specified queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of queue Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    QueueResourceInner get(String resourceGroupName, String namespaceName, String queueName);

    /**
     * Returns a description for the specified queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of queue Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<QueueResourceInner> getWithResponse(
        String resourceGroupName, String namespaceName, String queueName, Context context);

    /**
     * Gets all authorization rules for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all authorization rules for a queue.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SharedAccessAuthorizationRuleResourceInner> listAuthorizationRulesAsync(
        String resourceGroupName, String namespaceName, String queueName);

    /**
     * Gets all authorization rules for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all authorization rules for a queue.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SharedAccessAuthorizationRuleResourceInner> listAuthorizationRules(
        String resourceGroupName, String namespaceName, String queueName);

    /**
     * Gets all authorization rules for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all authorization rules for a queue.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SharedAccessAuthorizationRuleResourceInner> listAuthorizationRules(
        String resourceGroupName, String namespaceName, String queueName, Context context);

    /**
     * Creates an authorization rule for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @param parameters Parameters supplied to the Create Or Update Authorization Rules operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a namespace authorization rule.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SharedAccessAuthorizationRuleResourceInner>> createOrUpdateAuthorizationRuleWithResponseAsync(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        String authorizationRuleName,
        SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters);

    /**
     * Creates an authorization rule for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @param parameters Parameters supplied to the Create Or Update Authorization Rules operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a namespace authorization rule.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SharedAccessAuthorizationRuleResourceInner> createOrUpdateAuthorizationRuleAsync(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        String authorizationRuleName,
        SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters);

    /**
     * Creates an authorization rule for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @param parameters Parameters supplied to the Create Or Update Authorization Rules operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a namespace authorization rule.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SharedAccessAuthorizationRuleResourceInner createOrUpdateAuthorizationRule(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        String authorizationRuleName,
        SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters);

    /**
     * Creates an authorization rule for a queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @param parameters Parameters supplied to the Create Or Update Authorization Rules operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a namespace authorization rule.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SharedAccessAuthorizationRuleResourceInner> createOrUpdateAuthorizationRuleWithResponse(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        String authorizationRuleName,
        SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters,
        Context context);

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an authorization rule for a queue by rule name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SharedAccessAuthorizationRuleResourceInner>> postAuthorizationRuleWithResponseAsync(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an authorization rule for a queue by rule name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SharedAccessAuthorizationRuleResourceInner> postAuthorizationRuleAsync(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an authorization rule for a queue by rule name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SharedAccessAuthorizationRuleResourceInner postAuthorizationRule(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an authorization rule for a queue by rule name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SharedAccessAuthorizationRuleResourceInner> postAuthorizationRuleWithResponse(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        String authorizationRuleName,
        Context context);

    /**
     * Deletes a queue authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteAuthorizationRuleWithResponseAsync(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Deletes a queue authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAuthorizationRuleAsync(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Deletes a queue authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAuthorizationRule(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Deletes a queue authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteAuthorizationRuleWithResponse(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        String authorizationRuleName,
        Context context);

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an authorization rule for a queue by rule name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SharedAccessAuthorizationRuleResourceInner>> getAuthorizationRuleWithResponseAsync(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an authorization rule for a queue by rule name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SharedAccessAuthorizationRuleResourceInner> getAuthorizationRuleAsync(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an authorization rule for a queue by rule name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SharedAccessAuthorizationRuleResourceInner getAuthorizationRule(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Gets an authorization rule for a queue by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an authorization rule for a queue by rule name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SharedAccessAuthorizationRuleResourceInner> getAuthorizationRuleWithResponse(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        String authorizationRuleName,
        Context context);

    /**
     * Primary and secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace/ServiceBus Connection String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ResourceListKeysInner>> listKeysWithResponseAsync(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Primary and secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace/ServiceBus Connection String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ResourceListKeysInner> listKeysAsync(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Primary and secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace/ServiceBus Connection String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ResourceListKeysInner listKeys(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Primary and secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace/ServiceBus Connection String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ResourceListKeysInner> listKeysWithResponse(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        String authorizationRuleName,
        Context context);

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @param policykey Key that needs to be regenerated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace/ServiceBus Connection String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ResourceListKeysInner>> regenerateKeysWithResponseAsync(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        String authorizationRuleName,
        Policykey policykey);

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @param policykey Key that needs to be regenerated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace/ServiceBus Connection String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ResourceListKeysInner> regenerateKeysAsync(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        String authorizationRuleName,
        Policykey policykey);

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace/ServiceBus Connection String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ResourceListKeysInner> regenerateKeysAsync(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace/ServiceBus Connection String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ResourceListKeysInner regenerateKeys(
        String resourceGroupName, String namespaceName, String queueName, String authorizationRuleName);

    /**
     * Regenerates the primary or secondary connection strings to the queue.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name.
     * @param queueName The queue name.
     * @param authorizationRuleName The authorization rule name.
     * @param policykey Key that needs to be regenerated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace/ServiceBus Connection String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ResourceListKeysInner> regenerateKeysWithResponse(
        String resourceGroupName,
        String namespaceName,
        String queueName,
        String authorizationRuleName,
        Policykey policykey,
        Context context);
}
