// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for NamespaceState. */
public enum NamespaceState {
    /** Enum value Unknown. */
    UNKNOWN("Unknown"),

    /** Enum value Creating. */
    CREATING("Creating"),

    /** Enum value Created. */
    CREATED("Created"),

    /** Enum value Activating. */
    ACTIVATING("Activating"),

    /** Enum value Enabling. */
    ENABLING("Enabling"),

    /** Enum value Active. */
    ACTIVE("Active"),

    /** Enum value Disabling. */
    DISABLING("Disabling"),

    /** Enum value Disabled. */
    DISABLED("Disabled"),

    /** Enum value SoftDeleting. */
    SOFT_DELETING("SoftDeleting"),

    /** Enum value SoftDeleted. */
    SOFT_DELETED("SoftDeleted"),

    /** Enum value Removing. */
    REMOVING("Removing"),

    /** Enum value Removed. */
    REMOVED("Removed"),

    /** Enum value Failed. */
    FAILED("Failed");

    /** The actual serialized value for a NamespaceState instance. */
    private final String value;

    NamespaceState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a NamespaceState instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed NamespaceState object, or null if unable to parse.
     */
    @JsonCreator
    public static NamespaceState fromString(String value) {
        NamespaceState[] items = NamespaceState.values();
        for (NamespaceState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
