// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Parameters supplied to the Regenerate Authorization Rule operation. */
@Fluent
public final class RegenerateKeysParameters {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RegenerateKeysParameters.class);

    /*
     * Key that needs to be regenerated.
     */
    @JsonProperty(value = "Policykey")
    private Policykey policykey;

    /**
     * Get the policykey property: Key that needs to be regenerated.
     *
     * @return the policykey value.
     */
    public Policykey policykey() {
        return this.policykey;
    }

    /**
     * Set the policykey property: Key that needs to be regenerated.
     *
     * @param policykey the policykey value to set.
     * @return the RegenerateKeysParameters object itself.
     */
    public RegenerateKeysParameters withPolicykey(Policykey policykey) {
        this.policykey = policykey;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
