// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Parameters supplied to the Create Or Update Authorization Rules operation. */
@JsonFlatten
@Fluent
public class SharedAccessAuthorizationRuleCreateOrUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SharedAccessAuthorizationRuleCreateOrUpdateParameters.class);

    /*
     * data center location.
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * Name of the authorization rule.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The rights associated with the rule.
     */
    @JsonProperty(value = "properties.rights")
    private List<AccessRights> rights;

    /**
     * Get the location property: data center location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: data center location.
     *
     * @param location the location value to set.
     * @return the SharedAccessAuthorizationRuleCreateOrUpdateParameters object itself.
     */
    public SharedAccessAuthorizationRuleCreateOrUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the name property: Name of the authorization rule.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the authorization rule.
     *
     * @param name the name value to set.
     * @return the SharedAccessAuthorizationRuleCreateOrUpdateParameters object itself.
     */
    public SharedAccessAuthorizationRuleCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the rights property: The rights associated with the rule.
     *
     * @return the rights value.
     */
    public List<AccessRights> rights() {
        return this.rights;
    }

    /**
     * Set the rights property: The rights associated with the rule.
     *
     * @param rights the rights value to set.
     * @return the SharedAccessAuthorizationRuleCreateOrUpdateParameters object itself.
     */
    public SharedAccessAuthorizationRuleCreateOrUpdateParameters withRights(List<AccessRights> rights) {
        this.rights = rights;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
