// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.fluent.models.SubscriptionResourceInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The response to the List Subscriptions operation. */
@Fluent
public final class SubscriptionListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SubscriptionListResult.class);

    /*
     * Result of the List Subscriptions operation.
     */
    @JsonProperty(value = "value")
    private List<SubscriptionResourceInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete
     * list of subscriptions.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: Result of the List Subscriptions operation.
     *
     * @return the value value.
     */
    public List<SubscriptionResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Result of the List Subscriptions operation.
     *
     * @param value the value value to set.
     * @return the SubscriptionListResult object itself.
     */
    public SubscriptionListResult withValue(List<SubscriptionResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * subscriptions.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * subscriptions.
     *
     * @param nextLink the nextLink value to set.
     * @return the SubscriptionListResult object itself.
     */
    public SubscriptionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
