// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for UnavailableReason. */
public final class UnavailableReason extends ExpandableStringEnum<UnavailableReason> {
    /** Static value None for UnavailableReason. */
    public static final UnavailableReason NONE = fromString("None");

    /** Static value InvalidName for UnavailableReason. */
    public static final UnavailableReason INVALID_NAME = fromString("InvalidName");

    /** Static value SubscriptionIsDisabled for UnavailableReason. */
    public static final UnavailableReason SUBSCRIPTION_IS_DISABLED = fromString("SubscriptionIsDisabled");

    /** Static value NameInUse for UnavailableReason. */
    public static final UnavailableReason NAME_IN_USE = fromString("NameInUse");

    /** Static value NameInLockdown for UnavailableReason. */
    public static final UnavailableReason NAME_IN_LOCKDOWN = fromString("NameInLockdown");

    /** Static value TooManyNamespaceInCurrentSubscription for UnavailableReason. */
    public static final UnavailableReason TOO_MANY_NAMESPACE_IN_CURRENT_SUBSCRIPTION =
        fromString("TooManyNamespaceInCurrentSubscription");

    /**
     * Creates or finds a UnavailableReason from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding UnavailableReason.
     */
    @JsonCreator
    public static UnavailableReason fromString(String name) {
        return fromString(name, UnavailableReason.class);
    }

    /** @return known UnavailableReason values. */
    public static Collection<UnavailableReason> values() {
        return values(UnavailableReason.class);
    }
}
