/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.resourcemanager.resources.fluentcore.arm.models.HasResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.arm.models.IndependentChildResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.azure.resourcemanager.servicebus.fluent.models.ResourceListKeysInner;
import com.azure.resourcemanager.servicebus.fluent.models.SharedAccessAuthorizationRuleResourceInner;
import com.azure.resourcemanager.servicebus.implementation.AuthorizationKeysImpl;
import com.azure.resourcemanager.servicebus.models.AccessRights;
import com.azure.resourcemanager.servicebus.models.AuthorizationKeys;
import com.azure.resourcemanager.servicebus.models.Policykey;
import com.azure.resourcemanager.servicebus.models.SharedAccessAuthorizationRuleCreateOrUpdateParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

abstract class AuthorizationRuleBaseImpl<FluentModelT extends IndependentChildResource<ManagerT, InnerModelT>, FluentParentModelT extends Resource & HasResourceGroup, InnerModelT extends SharedAccessAuthorizationRuleResourceInner, FluentModelImplT extends IndependentChildResourceImpl<FluentModelT, FluentParentModelT, InnerModelT, FluentModelImplT, ManagerT>, ManagerT>
extends IndependentChildResourceImpl<FluentModelT, FluentParentModelT, InnerModelT, FluentModelImplT, ManagerT> {
    protected AuthorizationRuleBaseImpl(String name, InnerModelT innerObject, ManagerT manager) {
        super(name, innerObject, manager);
    }

    public Mono<AuthorizationKeys> getKeysAsync() {
        return this.getKeysInnerAsync().map(inner -> new AuthorizationKeysImpl((ResourceListKeysInner)inner));
    }

    public AuthorizationKeys getKeys() {
        return (AuthorizationKeys)this.getKeysAsync().block();
    }

    public Mono<AuthorizationKeys> regenerateKeyAsync(Policykey policykey) {
        return this.regenerateKeysInnerAsync(policykey).map(inner -> new AuthorizationKeysImpl((ResourceListKeysInner)inner));
    }

    public AuthorizationKeys regenerateKey(Policykey policykey) {
        return (AuthorizationKeys)this.regenerateKeyAsync(policykey).block();
    }

    public List<AccessRights> rights() {
        if (((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).rights() == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).rights());
    }

    public FluentModelImplT withListeningEnabled() {
        if (((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).rights() == null) {
            ((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).withRights(new ArrayList<AccessRights>());
        }
        if (!((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).rights().contains((Object)AccessRights.LISTEN)) {
            ((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).rights().add(AccessRights.LISTEN);
        }
        return (FluentModelImplT)((Object)this);
    }

    public FluentModelImplT withSendingEnabled() {
        if (((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).rights() == null) {
            ((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).withRights(new ArrayList<AccessRights>());
        }
        if (!((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).rights().contains((Object)AccessRights.SEND)) {
            ((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).rights().add(AccessRights.SEND);
        }
        return (FluentModelImplT)((Object)this);
    }

    public FluentModelImplT withManagementEnabled() {
        this.withListeningEnabled();
        this.withSendingEnabled();
        if (!((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).rights().contains((Object)AccessRights.MANAGE)) {
            ((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel())).rights().add(AccessRights.MANAGE);
        }
        return (FluentModelImplT)((Object)this);
    }

    protected SharedAccessAuthorizationRuleCreateOrUpdateParameters prepareForCreate(SharedAccessAuthorizationRuleResourceInner inner) {
        return new SharedAccessAuthorizationRuleCreateOrUpdateParameters().withRights(inner.rights());
    }

    protected abstract Mono<ResourceListKeysInner> getKeysInnerAsync();

    protected abstract Mono<ResourceListKeysInner> regenerateKeysInnerAsync(Policykey var1);
}

