/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.QueuesClient;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.models.SharedAccessAuthorizationRuleResourceInner;
import com.azure.resourcemanager.servicebus.implementation.QueueAuthorizationRuleImpl;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.azure.resourcemanager.servicebus.models.Queue;
import com.azure.resourcemanager.servicebus.models.QueueAuthorizationRule;
import com.azure.resourcemanager.servicebus.models.QueueAuthorizationRules;
import reactor.core.publisher.Mono;

class QueueAuthorizationRulesImpl
extends ServiceBusChildResourcesImpl<QueueAuthorizationRule, QueueAuthorizationRuleImpl, SharedAccessAuthorizationRuleResourceInner, QueuesClient, ServiceBusManager, Queue>
implements QueueAuthorizationRules {
    private final String resourceGroupName;
    private final String namespaceName;
    private final String queueName;
    private final Region region;
    private final ClientLogger logger = new ClientLogger(QueueAuthorizationRulesImpl.class);

    QueueAuthorizationRulesImpl(String resourceGroupName, String namespaceName, String queueName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClient)manager.serviceClient()).getQueues(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.queueName = queueName;
        this.region = region;
    }

    public QueueAuthorizationRuleImpl define(String name) {
        return this.wrapModel(name);
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return ((QueuesClient)this.innerModel()).deleteAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, this.queueName, name);
    }

    @Override
    protected Mono<SharedAccessAuthorizationRuleResourceInner> getInnerByNameAsync(String name) {
        return ((QueuesClient)this.innerModel()).getAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, this.queueName, name);
    }

    @Override
    protected PagedFlux<SharedAccessAuthorizationRuleResourceInner> listInnerAsync() {
        return ((QueuesClient)this.innerModel()).listAuthorizationRulesAsync(this.resourceGroupName, this.namespaceName, this.queueName);
    }

    @Override
    protected PagedIterable<SharedAccessAuthorizationRuleResourceInner> listInner() {
        return ((QueuesClient)this.innerModel()).listAuthorizationRules(this.resourceGroupName, this.namespaceName, this.queueName);
    }

    protected QueueAuthorizationRuleImpl wrapModel(String name) {
        return new QueueAuthorizationRuleImpl(this.resourceGroupName, this.namespaceName, this.queueName, name, this.region, new SharedAccessAuthorizationRuleResourceInner(), (ServiceBusManager)this.manager());
    }

    protected QueueAuthorizationRuleImpl wrapModel(SharedAccessAuthorizationRuleResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return new QueueAuthorizationRuleImpl(this.resourceGroupName, this.namespaceName, this.queueName, inner.name(), this.region, inner, (ServiceBusManager)this.manager());
    }

    public PagedIterable<QueueAuthorizationRule> listByParent(String resourceGroupName, String parentName) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }

    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }

    public Mono<QueueAuthorizationRule> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }
}

