/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.models.QueueResourceInner;
import com.azure.resourcemanager.servicebus.implementation.AuthorizationRuleBaseImpl;
import com.azure.resourcemanager.servicebus.implementation.QueueAuthorizationRulesImpl;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusNamespaceImpl;
import com.azure.resourcemanager.servicebus.implementation.TimeSpan;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.Queue;
import com.azure.resourcemanager.servicebus.models.QueueAuthorizationRule;
import com.azure.resourcemanager.servicebus.models.QueueCreateOrUpdateParameters;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class QueueImpl
extends IndependentChildResourceImpl<Queue, ServiceBusNamespaceImpl, QueueResourceInner, QueueImpl, ServiceBusManager>
implements Queue,
Queue.Definition,
Queue.Update {
    private List<Creatable<QueueAuthorizationRule>> rulesToCreate;
    private List<String> rulesToDelete;

    QueueImpl(String resourceGroupName, String namespaceName, String name, Region region, QueueResourceInner inner, ServiceBusManager manager) {
        super(name, (Resource)inner, (Object)manager);
        this.withExistingParentResource(resourceGroupName, namespaceName);
        this.initChildrenOperationsCache();
        if (inner.location() == null) {
            inner.withLocation(region.toString());
        }
    }

    @Override
    public OffsetDateTime createdAt() {
        return ((QueueResourceInner)((Object)this.innerModel())).createdAt();
    }

    @Override
    public OffsetDateTime accessedAt() {
        return ((QueueResourceInner)((Object)this.innerModel())).accessedAt();
    }

    @Override
    public OffsetDateTime updatedAt() {
        return ((QueueResourceInner)((Object)this.innerModel())).updatedAt();
    }

    @Override
    public long maxSizeInMB() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((QueueResourceInner)((Object)this.innerModel())).maxSizeInMegabytes());
    }

    @Override
    public long currentSizeInBytes() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((QueueResourceInner)((Object)this.innerModel())).sizeInBytes());
    }

    @Override
    public boolean isBatchedOperationsEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((QueueResourceInner)((Object)this.innerModel())).enableBatchedOperations());
    }

    @Override
    public boolean isDeadLetteringEnabledForExpiredMessages() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((QueueResourceInner)((Object)this.innerModel())).deadLetteringOnMessageExpiration());
    }

    @Override
    public boolean isExpressEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((QueueResourceInner)((Object)this.innerModel())).enableExpress());
    }

    @Override
    public boolean isPartitioningEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((QueueResourceInner)((Object)this.innerModel())).enablePartitioning());
    }

    @Override
    public boolean isSessionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((QueueResourceInner)((Object)this.innerModel())).requiresSession());
    }

    @Override
    public boolean isDuplicateDetectionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((QueueResourceInner)((Object)this.innerModel())).requiresDuplicateDetection());
    }

    @Override
    public long lockDurationInSeconds() {
        if (((QueueResourceInner)((Object)this.innerModel())).lockDuration() == null) {
            return 0L;
        }
        TimeSpan timeSpan = TimeSpan.parse(((QueueResourceInner)((Object)this.innerModel())).lockDuration());
        return (long)timeSpan.totalSeconds();
    }

    @Override
    public long deleteOnIdleDurationInMinutes() {
        if (((QueueResourceInner)((Object)this.innerModel())).autoDeleteOnIdle() == null) {
            return 0L;
        }
        TimeSpan timeSpan = TimeSpan.parse(((QueueResourceInner)((Object)this.innerModel())).autoDeleteOnIdle());
        return (long)timeSpan.totalMinutes();
    }

    @Override
    public Duration defaultMessageTtlDuration() {
        if (((QueueResourceInner)((Object)this.innerModel())).defaultMessageTimeToLive() == null) {
            return null;
        }
        return TimeSpan.parse(((QueueResourceInner)((Object)this.innerModel())).defaultMessageTimeToLive()).toDuration();
    }

    @Override
    public Duration duplicateMessageDetectionHistoryDuration() {
        if (((QueueResourceInner)((Object)this.innerModel())).duplicateDetectionHistoryTimeWindow() == null) {
            return null;
        }
        return TimeSpan.parse(((QueueResourceInner)((Object)this.innerModel())).duplicateDetectionHistoryTimeWindow()).toDuration();
    }

    @Override
    public int maxDeliveryCountBeforeDeadLetteringMessage() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((QueueResourceInner)((Object)this.innerModel())).maxDeliveryCount());
    }

    @Override
    public long messageCount() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((QueueResourceInner)((Object)this.innerModel())).messageCount());
    }

    @Override
    public long activeMessageCount() {
        if (((QueueResourceInner)((Object)this.innerModel())).countDetails() == null || ((QueueResourceInner)((Object)this.innerModel())).countDetails().activeMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((QueueResourceInner)((Object)this.innerModel())).countDetails().activeMessageCount());
    }

    @Override
    public long deadLetterMessageCount() {
        if (((QueueResourceInner)((Object)this.innerModel())).countDetails() == null || ((QueueResourceInner)((Object)this.innerModel())).countDetails().deadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((QueueResourceInner)((Object)this.innerModel())).countDetails().deadLetterMessageCount());
    }

    @Override
    public long scheduledMessageCount() {
        if (((QueueResourceInner)((Object)this.innerModel())).countDetails() == null || ((QueueResourceInner)((Object)this.innerModel())).countDetails().scheduledMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((QueueResourceInner)((Object)this.innerModel())).countDetails().scheduledMessageCount());
    }

    @Override
    public long transferDeadLetterMessageCount() {
        if (((QueueResourceInner)((Object)this.innerModel())).countDetails() == null || ((QueueResourceInner)((Object)this.innerModel())).countDetails().transferDeadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((QueueResourceInner)((Object)this.innerModel())).countDetails().transferDeadLetterMessageCount());
    }

    @Override
    public long transferMessageCount() {
        if (((QueueResourceInner)((Object)this.innerModel())).countDetails() == null || ((QueueResourceInner)((Object)this.innerModel())).countDetails().transferMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((QueueResourceInner)((Object)this.innerModel())).countDetails().transferMessageCount());
    }

    @Override
    public EntityStatus status() {
        return ((QueueResourceInner)((Object)this.innerModel())).status();
    }

    @Override
    public QueueAuthorizationRulesImpl authorizationRules() {
        return new QueueAuthorizationRulesImpl(this.resourceGroupName(), this.parentName, this.name(), this.region(), (ServiceBusManager)((Object)this.manager()));
    }

    @Override
    public QueueImpl withSizeInMB(long sizeInMB) {
        ((QueueResourceInner)((Object)this.innerModel())).withMaxSizeInMegabytes(sizeInMB);
        return this;
    }

    @Override
    public QueueImpl withPartitioning() {
        ((QueueResourceInner)((Object)this.innerModel())).withEnablePartitioning(true);
        return this;
    }

    @Override
    public QueueImpl withoutPartitioning() {
        ((QueueResourceInner)((Object)this.innerModel())).withEnablePartitioning(false);
        return this;
    }

    @Override
    public QueueImpl withDeleteOnIdleDurationInMinutes(int durationInMinutes) {
        TimeSpan timeSpan = new TimeSpan().withMinutes(durationInMinutes);
        ((QueueResourceInner)((Object)this.innerModel())).withAutoDeleteOnIdle(timeSpan.toString());
        return this;
    }

    @Override
    public QueueImpl withMessageLockDurationInSeconds(int durationInSeconds) {
        TimeSpan timeSpan = new TimeSpan().withSeconds(durationInSeconds);
        ((QueueResourceInner)((Object)this.innerModel())).withLockDuration(timeSpan.toString());
        return this;
    }

    @Override
    public QueueImpl withDefaultMessageTTL(Duration ttl) {
        ((QueueResourceInner)((Object)this.innerModel())).withDefaultMessageTimeToLive(TimeSpan.fromDuration(ttl).toString());
        return this;
    }

    @Override
    public QueueImpl withSession() {
        ((QueueResourceInner)((Object)this.innerModel())).withRequiresSession(true);
        return this;
    }

    @Override
    public QueueImpl withoutSession() {
        ((QueueResourceInner)((Object)this.innerModel())).withRequiresSession(false);
        return this;
    }

    @Override
    public QueueImpl withExpressMessage() {
        ((QueueResourceInner)((Object)this.innerModel())).withEnableExpress(true);
        return this;
    }

    @Override
    public QueueImpl withoutExpressMessage() {
        ((QueueResourceInner)((Object)this.innerModel())).withEnableExpress(false);
        return this;
    }

    @Override
    public QueueImpl withMessageBatching() {
        ((QueueResourceInner)((Object)this.innerModel())).withEnableBatchedOperations(true);
        return this;
    }

    @Override
    public QueueImpl withoutMessageBatching() {
        ((QueueResourceInner)((Object)this.innerModel())).withEnableBatchedOperations(false);
        return this;
    }

    @Override
    public QueueImpl withExpiredMessageMovedToDeadLetterQueue() {
        ((QueueResourceInner)((Object)this.innerModel())).withDeadLetteringOnMessageExpiration(true);
        return this;
    }

    @Override
    public QueueImpl withoutExpiredMessageMovedToDeadLetterQueue() {
        ((QueueResourceInner)((Object)this.innerModel())).withDeadLetteringOnMessageExpiration(false);
        return this;
    }

    @Override
    public QueueImpl withMessageMovedToDeadLetterQueueOnMaxDeliveryCount(int deliveryCount) {
        ((QueueResourceInner)((Object)this.innerModel())).withMaxDeliveryCount(deliveryCount);
        return this;
    }

    @Override
    public QueueImpl withDuplicateMessageDetection(Duration duplicateDetectionHistoryDuration) {
        ((QueueResourceInner)((Object)this.innerModel())).withRequiresDuplicateDetection(true);
        ((QueueResourceInner)((Object)this.innerModel())).withDuplicateDetectionHistoryTimeWindow(TimeSpan.fromDuration(duplicateDetectionHistoryDuration).toString());
        return this;
    }

    @Override
    public QueueImpl withDuplicateMessageDetectionHistoryDuration(Duration duration) {
        return this.withDuplicateMessageDetection(duration);
    }

    @Override
    public QueueImpl withoutDuplicateMessageDetection() {
        ((QueueResourceInner)((Object)this.innerModel())).withRequiresDuplicateDetection(false);
        return this;
    }

    @Override
    public QueueImpl withNewSendRule(String name) {
        this.rulesToCreate.add((Creatable<QueueAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withSendingEnabled());
        return this;
    }

    @Override
    public QueueImpl withNewListenRule(String name) {
        this.rulesToCreate.add((Creatable<QueueAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withListeningEnabled());
        return this;
    }

    @Override
    public QueueImpl withNewManageRule(String name) {
        this.rulesToCreate.add((Creatable<QueueAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withManagementEnabled());
        return this;
    }

    @Override
    public QueueImpl withoutAuthorizationRule(String name) {
        this.rulesToDelete.add(name);
        return this;
    }

    protected Mono<QueueResourceInner> getInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getQueues().getAsync(this.resourceGroupName(), this.parentName, this.name());
    }

    protected Mono<Queue> createChildResourceAsync() {
        Mono createTask = ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getQueues().createOrUpdateAsync(this.resourceGroupName(), this.parentName, this.name(), this.prepareForCreate((QueueResourceInner)((Object)this.innerModel()))).map(inner -> {
            this.setInner(inner);
            return inner;
        });
        Flux<Void> childOperationTasks = this.submitChildrenOperationsAsync();
        QueueImpl self = this;
        return Flux.concat((Publisher[])new Publisher[]{createTask, childOperationTasks}).doOnTerminate(() -> this.initChildrenOperationsCache()).then(Mono.just((Object)self));
    }

    private void initChildrenOperationsCache() {
        this.rulesToCreate = new ArrayList<Creatable<QueueAuthorizationRule>>();
        this.rulesToDelete = new ArrayList<String>();
    }

    private Flux<Void> submitChildrenOperationsAsync() {
        Flux rulesCreateStream = Flux.empty();
        if (this.rulesToCreate.size() > 0) {
            rulesCreateStream = this.authorizationRules().createAsync(this.rulesToCreate).then().flux();
        }
        Flux<Void> rulesDeleteStream = Flux.empty();
        if (this.rulesToDelete.size() > 0) {
            rulesDeleteStream = this.authorizationRules().deleteByNameAsync(this.rulesToDelete);
        }
        return Flux.mergeDelayError((int)32, (Publisher[])new Publisher[]{rulesCreateStream, rulesDeleteStream});
    }

    private QueueCreateOrUpdateParameters prepareForCreate(QueueResourceInner inner) {
        return new QueueCreateOrUpdateParameters().withLockDuration(inner.lockDuration()).withAutoDeleteOnIdle(inner.autoDeleteOnIdle()).withEntityAvailabilityStatus(inner.entityAvailabilityStatus()).withDefaultMessageTimeToLive(inner.defaultMessageTimeToLive()).withDuplicateDetectionHistoryTimeWindow(inner.duplicateDetectionHistoryTimeWindow()).withEnableBatchedOperations(inner.enableBatchedOperations()).withDeadLetteringOnMessageExpiration(inner.deadLetteringOnMessageExpiration()).withEnableExpress(inner.enableExpress()).withEnablePartitioning(inner.enablePartitioning()).withIsAnonymousAccessible(inner.isAnonymousAccessible()).withMaxDeliveryCount(inner.maxDeliveryCount()).withMaxSizeInMegabytes(inner.maxSizeInMegabytes()).withRequiresDuplicateDetection(inner.requiresDuplicateDetection()).withRequiresSession(inner.requiresSession()).withStatus(inner.status()).withSupportOrdering(inner.supportOrdering()).withLocation(inner.location());
    }
}

