/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.QueuesClient;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.models.QueueResourceInner;
import com.azure.resourcemanager.servicebus.implementation.QueueImpl;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.azure.resourcemanager.servicebus.models.Queue;
import com.azure.resourcemanager.servicebus.models.Queues;
import com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import reactor.core.publisher.Mono;

class QueuesImpl
extends ServiceBusChildResourcesImpl<Queue, QueueImpl, QueueResourceInner, QueuesClient, ServiceBusManager, ServiceBusNamespace>
implements Queues {
    private final String resourceGroupName;
    private final String namespaceName;
    private final Region region;
    private final ClientLogger logger = new ClientLogger(QueuesImpl.class);

    QueuesImpl(String resourceGroupName, String namespaceName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClient)manager.serviceClient()).getQueues(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.region = region;
    }

    public QueueImpl define(String name) {
        return this.wrapModel(name);
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return ((QueuesClient)this.innerModel()).deleteAsync(this.resourceGroupName, this.namespaceName, name);
    }

    @Override
    protected Mono<QueueResourceInner> getInnerByNameAsync(String name) {
        return ((QueuesClient)this.innerModel()).getAsync(this.resourceGroupName, this.namespaceName, name);
    }

    @Override
    protected PagedFlux<QueueResourceInner> listInnerAsync() {
        return ((QueuesClient)this.innerModel()).listAllAsync(this.resourceGroupName, this.namespaceName);
    }

    @Override
    protected PagedIterable<QueueResourceInner> listInner() {
        return ((QueuesClient)this.innerModel()).listAll(this.resourceGroupName, this.namespaceName);
    }

    protected QueueImpl wrapModel(String name) {
        return new QueueImpl(this.resourceGroupName, this.namespaceName, name, this.region, new QueueResourceInner(), (ServiceBusManager)this.manager());
    }

    protected QueueImpl wrapModel(QueueResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return new QueueImpl(this.resourceGroupName, this.namespaceName, inner.name(), this.region, inner, (ServiceBusManager)this.manager());
    }

    public PagedIterable<Queue> listByParent(String resourceGroupName, String parentName) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }

    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }

    public Mono<Queue> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }
}

