/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.azure.resourcemanager.servicebus.fluent.NamespacesClient;
import com.azure.resourcemanager.servicebus.fluent.OperationsClient;
import com.azure.resourcemanager.servicebus.fluent.QueuesClient;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.SubscriptionsClient;
import com.azure.resourcemanager.servicebus.fluent.TopicsClient;
import com.azure.resourcemanager.servicebus.implementation.NamespacesClientImpl;
import com.azure.resourcemanager.servicebus.implementation.OperationsClientImpl;
import com.azure.resourcemanager.servicebus.implementation.QueuesClientImpl;
import com.azure.resourcemanager.servicebus.implementation.SubscriptionsClientImpl;
import com.azure.resourcemanager.servicebus.implementation.TopicsClientImpl;
import java.time.Duration;

public final class ServiceBusManagementClientImpl
extends AzureServiceClient
implements ServiceBusManagementClient {
    private final ClientLogger logger = new ClientLogger(ServiceBusManagementClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final NamespacesClient namespaces;
    private final QueuesClient queues;
    private final TopicsClient topics;
    private final SubscriptionsClient subscriptions;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public NamespacesClient getNamespaces() {
        return this.namespaces;
    }

    @Override
    public QueuesClient getQueues() {
        return this.queues;
    }

    @Override
    public TopicsClient getTopics() {
        return this.topics;
    }

    @Override
    public SubscriptionsClient getSubscriptions() {
        return this.subscriptions;
    }

    ServiceBusManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2015-08-01";
        this.operations = new OperationsClientImpl(this);
        this.namespaces = new NamespacesClientImpl(this);
        this.queues = new QueuesClientImpl(this);
        this.topics = new TopicsClientImpl(this);
        this.subscriptions = new SubscriptionsClientImpl(this);
    }
}

