/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.servicebus.fluent.SubscriptionsClient;
import com.azure.resourcemanager.servicebus.fluent.models.SubscriptionResourceInner;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusManagementClientImpl;
import com.azure.resourcemanager.servicebus.models.SubscriptionCreateOrUpdateParameters;
import com.azure.resourcemanager.servicebus.models.SubscriptionListResult;
import reactor.core.publisher.Mono;

public final class SubscriptionsClientImpl
implements SubscriptionsClient {
    private final ClientLogger logger = new ClientLogger(SubscriptionsClientImpl.class);
    private final SubscriptionsService service;
    private final ServiceBusManagementClientImpl client;

    SubscriptionsClientImpl(ServiceBusManagementClientImpl client) {
        this.service = (SubscriptionsService)RestProxy.create(SubscriptionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<SubscriptionResourceInner>> listAllSinglePageAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAll(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubscriptionListResult)res.getValue()).value(), ((SubscriptionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SubscriptionResourceInner>> listAllSinglePageAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAll(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubscriptionListResult)res.getValue()).value(), ((SubscriptionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<SubscriptionResourceInner> listAllAsync(String resourceGroupName, String namespaceName, String topicName) {
        return new PagedFlux(() -> this.listAllSinglePageAsync(resourceGroupName, namespaceName, topicName), nextLink -> this.listAllNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<SubscriptionResourceInner> listAllAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return new PagedFlux(() -> this.listAllSinglePageAsync(resourceGroupName, namespaceName, topicName, context), nextLink -> this.listAllNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<SubscriptionResourceInner> listAll(String resourceGroupName, String namespaceName, String topicName) {
        return new PagedIterable(this.listAllAsync(resourceGroupName, namespaceName, topicName));
    }

    @Override
    public PagedIterable<SubscriptionResourceInner> listAll(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return new PagedIterable(this.listAllAsync(resourceGroupName, namespaceName, topicName, context));
    }

    @Override
    public Mono<Response<SubscriptionResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionCreateOrUpdateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SubscriptionResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionCreateOrUpdateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public Mono<SubscriptionResourceInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionCreateOrUpdateParameters parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SubscriptionResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SubscriptionResourceInner createOrUpdate(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionCreateOrUpdateParameters parameters) {
        return (SubscriptionResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, namespaceName, topicName, subscriptionName, parameters).block());
    }

    @Override
    public Response<SubscriptionResourceInner> createOrUpdateWithResponse(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionCreateOrUpdateParameters parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        return this.deleteWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        this.deleteAsync(resourceGroupName, namespaceName, topicName, subscriptionName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, context).block();
    }

    @Override
    public Mono<Response<SubscriptionResourceInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SubscriptionResourceInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<SubscriptionResourceInner> getAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        return this.getWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SubscriptionResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SubscriptionResourceInner get(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        return (SubscriptionResourceInner)((Object)this.getAsync(resourceGroupName, namespaceName, topicName, subscriptionName).block());
    }

    @Override
    public Response<SubscriptionResourceInner> getWithResponse(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, context).block();
    }

    private Mono<PagedResponse<SubscriptionResourceInner>> listAllNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAllNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubscriptionListResult)res.getValue()).value(), ((SubscriptionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SubscriptionResourceInner>> listAllNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAllNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubscriptionListResult)res.getValue()).value(), ((SubscriptionListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ServiceBusManagement")
    private static interface SubscriptionsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SubscriptionListResult>> listAll(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SubscriptionResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="subscriptionName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") SubscriptionCreateOrUpdateParameters var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="subscriptionName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SubscriptionResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="subscriptionName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SubscriptionListResult>> listAllNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

