/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.management.Region;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.models.ResourceListKeysInner;
import com.azure.resourcemanager.servicebus.fluent.models.SharedAccessAuthorizationRuleResourceInner;
import com.azure.resourcemanager.servicebus.implementation.AuthorizationRuleBaseImpl;
import com.azure.resourcemanager.servicebus.implementation.TopicImpl;
import com.azure.resourcemanager.servicebus.models.Policykey;
import com.azure.resourcemanager.servicebus.models.TopicAuthorizationRule;
import reactor.core.publisher.Mono;

class TopicAuthorizationRuleImpl
extends AuthorizationRuleBaseImpl<TopicAuthorizationRule, TopicImpl, SharedAccessAuthorizationRuleResourceInner, TopicAuthorizationRuleImpl, ServiceBusManager>
implements TopicAuthorizationRule,
TopicAuthorizationRule.Definition,
TopicAuthorizationRule.Update {
    private final String namespaceName;
    private final Region region;

    TopicAuthorizationRuleImpl(String resourceGroupName, String namespaceName, String topicName, String name, Region region, SharedAccessAuthorizationRuleResourceInner inner, ServiceBusManager manager) {
        super(name, inner, manager);
        this.namespaceName = namespaceName;
        this.region = region;
        this.withExistingParentResource(resourceGroupName, topicName);
        if (inner.location() == null) {
            inner.withLocation(this.region.toString());
        }
    }

    @Override
    public String namespaceName() {
        return this.namespaceName;
    }

    @Override
    public String topicName() {
        return this.parentName;
    }

    protected Mono<SharedAccessAuthorizationRuleResourceInner> getInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getTopics().getAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.topicName(), this.name());
    }

    protected Mono<TopicAuthorizationRule> createChildResourceAsync() {
        TopicAuthorizationRuleImpl self = this;
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getTopics().createOrUpdateAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.topicName(), this.name(), this.prepareForCreate((SharedAccessAuthorizationRuleResourceInner)((Object)this.innerModel()))).map(inner -> {
            this.setInner(inner);
            return self;
        });
    }

    @Override
    protected Mono<ResourceListKeysInner> getKeysInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getTopics().listKeysAsync(this.resourceGroupName(), this.namespaceName(), this.topicName(), this.name());
    }

    @Override
    protected Mono<ResourceListKeysInner> regenerateKeysInnerAsync(Policykey policykey) {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getTopics().regenerateKeysAsync(this.resourceGroupName(), this.namespaceName(), this.topicName(), this.name(), policykey);
    }
}

