/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.models.TopicResourceInner;
import com.azure.resourcemanager.servicebus.implementation.AuthorizationRuleBaseImpl;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusNamespaceImpl;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusSubscriptionsImpl;
import com.azure.resourcemanager.servicebus.implementation.TimeSpan;
import com.azure.resourcemanager.servicebus.implementation.TopicAuthorizationRulesImpl;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.ServiceBusSubscription;
import com.azure.resourcemanager.servicebus.models.Topic;
import com.azure.resourcemanager.servicebus.models.TopicAuthorizationRule;
import com.azure.resourcemanager.servicebus.models.TopicCreateOrUpdateParameters;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class TopicImpl
extends IndependentChildResourceImpl<Topic, ServiceBusNamespaceImpl, TopicResourceInner, TopicImpl, ServiceBusManager>
implements Topic,
Topic.Definition,
Topic.Update {
    private List<Creatable<ServiceBusSubscription>> subscriptionsToCreate;
    private List<Creatable<TopicAuthorizationRule>> rulesToCreate;
    private List<String> subscriptionsToDelete;
    private List<String> rulesToDelete;

    TopicImpl(String resourceGroupName, String namespaceName, String name, Region region, TopicResourceInner inner, ServiceBusManager manager) {
        super(name, (Resource)inner, (Object)manager);
        this.withExistingParentResource(resourceGroupName, namespaceName);
        this.initChildrenOperationsCache();
        if (inner.location() == null) {
            inner.withLocation(region.toString());
        }
    }

    @Override
    public OffsetDateTime createdAt() {
        return ((TopicResourceInner)((Object)this.innerModel())).createdAt();
    }

    @Override
    public OffsetDateTime accessedAt() {
        return ((TopicResourceInner)((Object)this.innerModel())).accessedAt();
    }

    @Override
    public OffsetDateTime updatedAt() {
        return ((TopicResourceInner)((Object)this.innerModel())).updatedAt();
    }

    @Override
    public long maxSizeInMB() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((TopicResourceInner)((Object)this.innerModel())).maxSizeInMegabytes());
    }

    @Override
    public long currentSizeInBytes() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((TopicResourceInner)((Object)this.innerModel())).sizeInBytes());
    }

    @Override
    public boolean isBatchedOperationsEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((TopicResourceInner)((Object)this.innerModel())).enableBatchedOperations());
    }

    @Override
    public boolean isExpressEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((TopicResourceInner)((Object)this.innerModel())).enableExpress());
    }

    @Override
    public boolean isPartitioningEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((TopicResourceInner)((Object)this.innerModel())).enablePartitioning());
    }

    @Override
    public boolean isDuplicateDetectionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((TopicResourceInner)((Object)this.innerModel())).requiresDuplicateDetection());
    }

    @Override
    public long deleteOnIdleDurationInMinutes() {
        if (((TopicResourceInner)((Object)this.innerModel())).autoDeleteOnIdle() == null) {
            return 0L;
        }
        TimeSpan timeSpan = TimeSpan.parse(((TopicResourceInner)((Object)this.innerModel())).autoDeleteOnIdle());
        return (long)timeSpan.totalMinutes();
    }

    @Override
    public Duration defaultMessageTtlDuration() {
        if (((TopicResourceInner)((Object)this.innerModel())).defaultMessageTimeToLive() == null) {
            return null;
        }
        return TimeSpan.parse(((TopicResourceInner)((Object)this.innerModel())).defaultMessageTimeToLive()).toDuration();
    }

    @Override
    public Duration duplicateMessageDetectionHistoryDuration() {
        if (((TopicResourceInner)((Object)this.innerModel())).duplicateDetectionHistoryTimeWindow() == null) {
            return null;
        }
        return TimeSpan.parse(((TopicResourceInner)((Object)this.innerModel())).duplicateDetectionHistoryTimeWindow()).toDuration();
    }

    @Override
    public long activeMessageCount() {
        if (((TopicResourceInner)((Object)this.innerModel())).countDetails() == null || ((TopicResourceInner)((Object)this.innerModel())).countDetails().activeMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((TopicResourceInner)((Object)this.innerModel())).countDetails().activeMessageCount());
    }

    @Override
    public long deadLetterMessageCount() {
        if (((TopicResourceInner)((Object)this.innerModel())).countDetails() == null || ((TopicResourceInner)((Object)this.innerModel())).countDetails().deadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((TopicResourceInner)((Object)this.innerModel())).countDetails().deadLetterMessageCount());
    }

    @Override
    public long scheduledMessageCount() {
        if (((TopicResourceInner)((Object)this.innerModel())).countDetails() == null || ((TopicResourceInner)((Object)this.innerModel())).countDetails().scheduledMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((TopicResourceInner)((Object)this.innerModel())).countDetails().scheduledMessageCount());
    }

    @Override
    public long transferDeadLetterMessageCount() {
        if (((TopicResourceInner)((Object)this.innerModel())).countDetails() == null || ((TopicResourceInner)((Object)this.innerModel())).countDetails().transferDeadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((TopicResourceInner)((Object)this.innerModel())).countDetails().transferDeadLetterMessageCount());
    }

    @Override
    public long transferMessageCount() {
        if (((TopicResourceInner)((Object)this.innerModel())).countDetails() == null || ((TopicResourceInner)((Object)this.innerModel())).countDetails().transferMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((TopicResourceInner)((Object)this.innerModel())).countDetails().transferMessageCount());
    }

    @Override
    public int subscriptionCount() {
        if (((TopicResourceInner)((Object)this.innerModel())).subscriptionCount() == null) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt((Integer)((TopicResourceInner)((Object)this.innerModel())).subscriptionCount());
    }

    @Override
    public EntityStatus status() {
        return ((TopicResourceInner)((Object)this.innerModel())).status();
    }

    @Override
    public ServiceBusSubscriptionsImpl subscriptions() {
        return new ServiceBusSubscriptionsImpl(this.resourceGroupName(), this.parentName, this.name(), this.region(), (ServiceBusManager)((Object)this.manager()));
    }

    @Override
    public TopicAuthorizationRulesImpl authorizationRules() {
        return new TopicAuthorizationRulesImpl(this.resourceGroupName(), this.parentName, this.name(), this.region(), (ServiceBusManager)((Object)this.manager()));
    }

    @Override
    public TopicImpl withSizeInMB(long sizeInMB) {
        ((TopicResourceInner)((Object)this.innerModel())).withMaxSizeInMegabytes(sizeInMB);
        return this;
    }

    @Override
    public TopicImpl withPartitioning() {
        ((TopicResourceInner)((Object)this.innerModel())).withEnablePartitioning(true);
        return this;
    }

    @Override
    public TopicImpl withoutPartitioning() {
        ((TopicResourceInner)((Object)this.innerModel())).withEnablePartitioning(false);
        return this;
    }

    @Override
    public TopicImpl withDeleteOnIdleDurationInMinutes(int durationInMinutes) {
        TimeSpan timeSpan = new TimeSpan().withMinutes(durationInMinutes);
        ((TopicResourceInner)((Object)this.innerModel())).withAutoDeleteOnIdle(timeSpan.toString());
        return this;
    }

    @Override
    public TopicImpl withDefaultMessageTTL(Duration ttl) {
        ((TopicResourceInner)((Object)this.innerModel())).withDefaultMessageTimeToLive(TimeSpan.fromDuration(ttl).toString());
        return this;
    }

    @Override
    public TopicImpl withExpressMessage() {
        ((TopicResourceInner)((Object)this.innerModel())).withEnableExpress(true);
        return this;
    }

    @Override
    public TopicImpl withoutExpressMessage() {
        ((TopicResourceInner)((Object)this.innerModel())).withEnableExpress(false);
        return this;
    }

    @Override
    public TopicImpl withMessageBatching() {
        ((TopicResourceInner)((Object)this.innerModel())).withEnableBatchedOperations(true);
        return this;
    }

    @Override
    public TopicImpl withoutMessageBatching() {
        ((TopicResourceInner)((Object)this.innerModel())).withEnableBatchedOperations(false);
        return this;
    }

    @Override
    public TopicImpl withDuplicateMessageDetection(Duration duplicateDetectionHistoryDuration) {
        ((TopicResourceInner)((Object)this.innerModel())).withRequiresDuplicateDetection(true);
        ((TopicResourceInner)((Object)this.innerModel())).withDuplicateDetectionHistoryTimeWindow(TimeSpan.fromDuration(duplicateDetectionHistoryDuration).toString());
        return this;
    }

    @Override
    public TopicImpl withDuplicateMessageDetectionHistoryDuration(Duration duration) {
        ((TopicResourceInner)((Object)this.innerModel())).withDuplicateDetectionHistoryTimeWindow(TimeSpan.fromDuration(duration).toString());
        return this;
    }

    @Override
    public TopicImpl withoutDuplicateMessageDetection() {
        ((TopicResourceInner)((Object)this.innerModel())).withRequiresDuplicateDetection(false);
        return this;
    }

    @Override
    public TopicImpl withNewSendRule(String name) {
        this.rulesToCreate.add((Creatable<TopicAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withSendingEnabled());
        return this;
    }

    @Override
    public TopicImpl withNewListenRule(String name) {
        this.rulesToCreate.add((Creatable<TopicAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withListeningEnabled());
        return this;
    }

    @Override
    public TopicImpl withNewManageRule(String name) {
        this.rulesToCreate.add((Creatable<TopicAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withManagementEnabled());
        return this;
    }

    @Override
    public TopicImpl withoutAuthorizationRule(String name) {
        this.rulesToDelete.add(name);
        return this;
    }

    @Override
    public TopicImpl withNewSubscription(String name) {
        this.subscriptionsToCreate.add(this.subscriptions().define(name));
        return this;
    }

    @Override
    public TopicImpl withoutSubscription(String name) {
        this.subscriptionsToDelete.add(name);
        return this;
    }

    protected Mono<TopicResourceInner> getInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getTopics().getAsync(this.resourceGroupName(), this.parentName, this.name());
    }

    protected Mono<Topic> createChildResourceAsync() {
        Mono createTask = ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getTopics().createOrUpdateAsync(this.resourceGroupName(), this.parentName, this.name(), this.prepareForCreate((TopicResourceInner)((Object)this.innerModel()))).map(inner -> {
            this.setInner(inner);
            return inner;
        });
        Flux<Void> childOperationTasks = this.submitChildrenOperationsAsync();
        TopicImpl self = this;
        return Flux.concat((Publisher[])new Publisher[]{createTask, childOperationTasks}).doOnTerminate(() -> this.initChildrenOperationsCache()).then(Mono.just((Object)self));
    }

    private void initChildrenOperationsCache() {
        this.subscriptionsToCreate = new ArrayList<Creatable<ServiceBusSubscription>>();
        this.rulesToCreate = new ArrayList<Creatable<TopicAuthorizationRule>>();
        this.subscriptionsToDelete = new ArrayList<String>();
        this.rulesToDelete = new ArrayList<String>();
    }

    private Flux<Void> submitChildrenOperationsAsync() {
        Flux subscriptionsCreateStream = Flux.empty();
        if (this.subscriptionsToCreate.size() > 0) {
            subscriptionsCreateStream = this.subscriptions().createAsync(this.subscriptionsToCreate).then().flux();
        }
        Flux rulesCreateStream = Flux.empty();
        if (this.rulesToCreate.size() > 0) {
            rulesCreateStream = this.authorizationRules().createAsync(this.rulesToCreate).then().flux();
        }
        Flux<Void> subscriptionsDeleteStream = Flux.empty();
        if (this.subscriptionsToDelete.size() > 0) {
            subscriptionsDeleteStream = this.subscriptions().deleteByNameAsync(this.subscriptionsToDelete);
        }
        Flux<Void> rulesDeleteStream = Flux.empty();
        if (this.rulesToDelete.size() > 0) {
            rulesDeleteStream = this.authorizationRules().deleteByNameAsync(this.rulesToDelete);
        }
        return Flux.mergeDelayError((int)32, (Publisher[])new Publisher[]{subscriptionsCreateStream, rulesCreateStream, subscriptionsDeleteStream, rulesDeleteStream});
    }

    private TopicCreateOrUpdateParameters prepareForCreate(TopicResourceInner inner) {
        return new TopicCreateOrUpdateParameters().withAutoDeleteOnIdle(inner.autoDeleteOnIdle()).withEntityAvailabilityStatus(inner.entityAvailabilityStatus()).withDefaultMessageTimeToLive(inner.defaultMessageTimeToLive()).withDuplicateDetectionHistoryTimeWindow(inner.duplicateDetectionHistoryTimeWindow()).withEnableBatchedOperations(inner.enableBatchedOperations()).withEnableExpress(inner.enableExpress()).withEnablePartitioning(inner.enablePartitioning()).withFilteringMessagesBeforePublishing(inner.filteringMessagesBeforePublishing()).withIsAnonymousAccessible(inner.isAnonymousAccessible()).withIsExpress(inner.isExpress()).withMaxSizeInMegabytes(inner.maxSizeInMegabytes()).withRequiresDuplicateDetection(inner.requiresDuplicateDetection()).withStatus(inner.status()).withSupportOrdering(inner.supportOrdering()).withLocation(inner.location());
    }
}

