/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.servicebus.fluent.TopicsClient;
import com.azure.resourcemanager.servicebus.fluent.models.ResourceListKeysInner;
import com.azure.resourcemanager.servicebus.fluent.models.SharedAccessAuthorizationRuleResourceInner;
import com.azure.resourcemanager.servicebus.fluent.models.TopicResourceInner;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusManagementClientImpl;
import com.azure.resourcemanager.servicebus.models.Policykey;
import com.azure.resourcemanager.servicebus.models.RegenerateKeysParameters;
import com.azure.resourcemanager.servicebus.models.SharedAccessAuthorizationRuleCreateOrUpdateParameters;
import com.azure.resourcemanager.servicebus.models.SharedAccessAuthorizationRuleListResult;
import com.azure.resourcemanager.servicebus.models.TopicCreateOrUpdateParameters;
import com.azure.resourcemanager.servicebus.models.TopicListResult;
import reactor.core.publisher.Mono;

public final class TopicsClientImpl
implements TopicsClient {
    private final ClientLogger logger = new ClientLogger(TopicsClientImpl.class);
    private final TopicsService service;
    private final ServiceBusManagementClientImpl client;

    TopicsClientImpl(ServiceBusManagementClientImpl client) {
        this.service = (TopicsService)RestProxy.create(TopicsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<TopicResourceInner>> listAllSinglePageAsync(String resourceGroupName, String namespaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAll(this.client.getEndpoint(), resourceGroupName, namespaceName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicListResult)res.getValue()).value(), ((TopicListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<TopicResourceInner>> listAllSinglePageAsync(String resourceGroupName, String namespaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAll(this.client.getEndpoint(), resourceGroupName, namespaceName, this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicListResult)res.getValue()).value(), ((TopicListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<TopicResourceInner> listAllAsync(String resourceGroupName, String namespaceName) {
        return new PagedFlux(() -> this.listAllSinglePageAsync(resourceGroupName, namespaceName), nextLink -> this.listAllNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<TopicResourceInner> listAllAsync(String resourceGroupName, String namespaceName, Context context) {
        return new PagedFlux(() -> this.listAllSinglePageAsync(resourceGroupName, namespaceName, context), nextLink -> this.listAllNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<TopicResourceInner> listAll(String resourceGroupName, String namespaceName) {
        return new PagedIterable(this.listAllAsync(resourceGroupName, namespaceName));
    }

    @Override
    public PagedIterable<TopicResourceInner> listAll(String resourceGroupName, String namespaceName, Context context) {
        return new PagedIterable(this.listAllAsync(resourceGroupName, namespaceName, context));
    }

    @Override
    public Mono<Response<TopicResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, TopicCreateOrUpdateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<TopicResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, TopicCreateOrUpdateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public Mono<TopicResourceInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, TopicCreateOrUpdateParameters parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, topicName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((TopicResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public TopicResourceInner createOrUpdate(String resourceGroupName, String namespaceName, String topicName, TopicCreateOrUpdateParameters parameters) {
        return (TopicResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, namespaceName, topicName, parameters).block());
    }

    @Override
    public Response<TopicResourceInner> createOrUpdateWithResponse(String resourceGroupName, String namespaceName, String topicName, TopicCreateOrUpdateParameters parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, topicName, parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.deleteWithResponseAsync(resourceGroupName, namespaceName, topicName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String topicName) {
        this.deleteAsync(resourceGroupName, namespaceName, topicName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, namespaceName, topicName, context).block();
    }

    @Override
    public Mono<Response<TopicResourceInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<TopicResourceInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<TopicResourceInner> getAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.getWithResponseAsync(resourceGroupName, namespaceName, topicName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((TopicResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public TopicResourceInner get(String resourceGroupName, String namespaceName, String topicName) {
        return (TopicResourceInner)((Object)this.getAsync(resourceGroupName, namespaceName, topicName).block());
    }

    @Override
    public Response<TopicResourceInner> getWithResponse(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, namespaceName, topicName, context).block();
    }

    private Mono<PagedResponse<SharedAccessAuthorizationRuleResourceInner>> listAuthorizationRulesSinglePageAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAuthorizationRules(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedAccessAuthorizationRuleListResult)res.getValue()).value(), ((SharedAccessAuthorizationRuleListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SharedAccessAuthorizationRuleResourceInner>> listAuthorizationRulesSinglePageAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAuthorizationRules(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedAccessAuthorizationRuleListResult)res.getValue()).value(), ((SharedAccessAuthorizationRuleListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<SharedAccessAuthorizationRuleResourceInner> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName, String topicName) {
        return new PagedFlux(() -> this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, topicName), nextLink -> this.listAuthorizationRulesNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<SharedAccessAuthorizationRuleResourceInner> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return new PagedFlux(() -> this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, topicName, context), nextLink -> this.listAuthorizationRulesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<SharedAccessAuthorizationRuleResourceInner> listAuthorizationRules(String resourceGroupName, String namespaceName, String topicName) {
        return new PagedIterable(this.listAuthorizationRulesAsync(resourceGroupName, namespaceName, topicName));
    }

    @Override
    public PagedIterable<SharedAccessAuthorizationRuleResourceInner> listAuthorizationRules(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return new PagedIterable(this.listAuthorizationRulesAsync(resourceGroupName, namespaceName, topicName, context));
    }

    @Override
    public Mono<Response<SharedAccessAuthorizationRuleResourceInner>> createOrUpdateAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdateAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SharedAccessAuthorizationRuleResourceInner>> createOrUpdateAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public Mono<SharedAccessAuthorizationRuleResourceInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters) {
        return this.createOrUpdateAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SharedAccessAuthorizationRuleResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SharedAccessAuthorizationRuleResourceInner createOrUpdateAuthorizationRule(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters) {
        return (SharedAccessAuthorizationRuleResourceInner)((Object)this.createOrUpdateAuthorizationRuleAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, parameters).block());
    }

    @Override
    public Response<SharedAccessAuthorizationRuleResourceInner> createOrUpdateAuthorizationRuleWithResponse(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters, Context context) {
        return (Response)this.createOrUpdateAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, parameters, context).block();
    }

    @Override
    public Mono<Response<SharedAccessAuthorizationRuleResourceInner>> postAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.postAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SharedAccessAuthorizationRuleResourceInner>> postAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.postAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<SharedAccessAuthorizationRuleResourceInner> postAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return this.postAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SharedAccessAuthorizationRuleResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SharedAccessAuthorizationRuleResourceInner postAuthorizationRule(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return (SharedAccessAuthorizationRuleResourceInner)((Object)this.postAuthorizationRuleAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).block());
    }

    @Override
    public Response<SharedAccessAuthorizationRuleResourceInner> postAuthorizationRuleWithResponse(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        return (Response)this.postAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, context).block();
    }

    @Override
    public Mono<Response<SharedAccessAuthorizationRuleResourceInner>> getAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SharedAccessAuthorizationRuleResourceInner>> getAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<SharedAccessAuthorizationRuleResourceInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return this.getAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SharedAccessAuthorizationRuleResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SharedAccessAuthorizationRuleResourceInner getAuthorizationRule(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return (SharedAccessAuthorizationRuleResourceInner)((Object)this.getAuthorizationRuleAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).block());
    }

    @Override
    public Response<SharedAccessAuthorizationRuleResourceInner> getAuthorizationRuleWithResponse(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        return (Response)this.getAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.deleteAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.deleteAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return this.deleteAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteAuthorizationRule(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        this.deleteAuthorizationRuleAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).block();
    }

    @Override
    public Response<Void> deleteAuthorizationRuleWithResponse(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        return (Response)this.deleteAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, context).block();
    }

    @Override
    public Mono<Response<ResourceListKeysInner>> listKeysWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listKeys(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ResourceListKeysInner>> listKeysWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listKeys(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<ResourceListKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return this.listKeysWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ResourceListKeysInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ResourceListKeysInner listKeys(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return (ResourceListKeysInner)this.listKeysAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).block();
    }

    @Override
    public Response<ResourceListKeysInner> listKeysWithResponse(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        return (Response)this.listKeysWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, context).block();
    }

    @Override
    public Mono<Response<ResourceListKeysInner>> regenerateKeysWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Policykey policykey) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        RegenerateKeysParameters parameters = new RegenerateKeysParameters();
        parameters.withPolicykey(policykey);
        return FluxUtil.withContext(context -> this.service.regenerateKeys(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ResourceListKeysInner>> regenerateKeysWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Policykey policykey, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        RegenerateKeysParameters parameters = new RegenerateKeysParameters();
        parameters.withPolicykey(policykey);
        context = this.client.mergeContext(context);
        return this.service.regenerateKeys(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public Mono<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Policykey policykey) {
        return this.regenerateKeysWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, policykey).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ResourceListKeysInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        Policykey policykey = null;
        return this.regenerateKeysWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, policykey).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ResourceListKeysInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ResourceListKeysInner regenerateKeys(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        Policykey policykey = null;
        return (ResourceListKeysInner)this.regenerateKeysAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, policykey).block();
    }

    @Override
    public Response<ResourceListKeysInner> regenerateKeysWithResponse(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Policykey policykey, Context context) {
        return (Response)this.regenerateKeysWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, policykey, context).block();
    }

    private Mono<PagedResponse<TopicResourceInner>> listAllNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAllNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicListResult)res.getValue()).value(), ((TopicListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<TopicResourceInner>> listAllNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAllNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicListResult)res.getValue()).value(), ((TopicListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<SharedAccessAuthorizationRuleResourceInner>> listAuthorizationRulesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAuthorizationRulesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedAccessAuthorizationRuleListResult)res.getValue()).value(), ((SharedAccessAuthorizationRuleListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SharedAccessAuthorizationRuleResourceInner>> listAuthorizationRulesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAuthorizationRulesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedAccessAuthorizationRuleListResult)res.getValue()).value(), ((SharedAccessAuthorizationRuleListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ServiceBusManagement")
    private static interface TopicsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicListResult>> listAll(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") TopicCreateOrUpdateParameters var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SharedAccessAuthorizationRuleListResult>> listAuthorizationRules(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SharedAccessAuthorizationRuleResourceInner>> createOrUpdateAuthorizationRule(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="authorizationRuleName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") SharedAccessAuthorizationRuleCreateOrUpdateParameters var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SharedAccessAuthorizationRuleResourceInner>> postAuthorizationRule(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="authorizationRuleName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SharedAccessAuthorizationRuleResourceInner>> getAuthorizationRule(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="authorizationRuleName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteAuthorizationRule(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="authorizationRuleName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}/ListKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceListKeysInner>> listKeys(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="authorizationRuleName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}/regenerateKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceListKeysInner>> regenerateKeys(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="authorizationRuleName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") RegenerateKeysParameters var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicListResult>> listAllNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SharedAccessAuthorizationRuleListResult>> listAuthorizationRulesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

