/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.TopicsClient;
import com.azure.resourcemanager.servicebus.fluent.models.TopicResourceInner;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.azure.resourcemanager.servicebus.implementation.TopicImpl;
import com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import com.azure.resourcemanager.servicebus.models.Topic;
import com.azure.resourcemanager.servicebus.models.Topics;
import reactor.core.publisher.Mono;

class TopicsImpl
extends ServiceBusChildResourcesImpl<Topic, TopicImpl, TopicResourceInner, TopicsClient, ServiceBusManager, ServiceBusNamespace>
implements Topics {
    private final String resourceGroupName;
    private final String namespaceName;
    private final Region region;
    private final ClientLogger logger = new ClientLogger(TopicsImpl.class);

    TopicsImpl(String resourceGroupName, String namespaceName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClient)manager.serviceClient()).getTopics(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.region = region;
    }

    public TopicImpl define(String name) {
        return this.wrapModel(name);
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return ((TopicsClient)this.innerModel()).deleteAsync(this.resourceGroupName, this.namespaceName, name);
    }

    @Override
    protected Mono<TopicResourceInner> getInnerByNameAsync(String name) {
        return ((TopicsClient)this.innerModel()).getAsync(this.resourceGroupName, this.namespaceName, name);
    }

    @Override
    protected PagedFlux<TopicResourceInner> listInnerAsync() {
        return ((TopicsClient)this.innerModel()).listAllAsync(this.resourceGroupName, this.namespaceName);
    }

    @Override
    protected PagedIterable<TopicResourceInner> listInner() {
        return ((TopicsClient)this.innerModel()).listAll(this.resourceGroupName, this.namespaceName);
    }

    protected TopicImpl wrapModel(String name) {
        return new TopicImpl(this.resourceGroupName, this.namespaceName, name, this.region, new TopicResourceInner(), (ServiceBusManager)this.manager());
    }

    protected TopicImpl wrapModel(TopicResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return new TopicImpl(this.resourceGroupName, this.namespaceName, inner.name(), this.region, inner, (ServiceBusManager)this.manager());
    }

    public PagedIterable<Topic> listByParent(String resourceGroupName, String parentName) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }

    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }

    public Mono<Topic> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }
}

