/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.models.NamespaceState;
import com.azure.resourcemanager.servicebus.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

@JsonFlatten
public class NamespaceCreateOrUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(NamespaceCreateOrUpdateParameters.class);
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.status")
    private NamespaceState status;
    @JsonProperty(value="properties.createdAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;
    @JsonProperty(value="properties.updatedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAt;
    @JsonProperty(value="properties.serviceBusEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String serviceBusEndpoint;
    @JsonProperty(value="properties.createACSNamespace")
    private Boolean createAcsNamespace;
    @JsonProperty(value="properties.enabled")
    private Boolean enabled;

    public String location() {
        return this.location;
    }

    public NamespaceCreateOrUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public NamespaceCreateOrUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public NamespaceCreateOrUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public NamespaceState status() {
        return this.status;
    }

    public NamespaceCreateOrUpdateParameters withStatus(NamespaceState status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public String serviceBusEndpoint() {
        return this.serviceBusEndpoint;
    }

    public Boolean createAcsNamespace() {
        return this.createAcsNamespace;
    }

    public NamespaceCreateOrUpdateParameters withCreateAcsNamespace(Boolean createAcsNamespace) {
        this.createAcsNamespace = createAcsNamespace;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public NamespaceCreateOrUpdateParameters withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model NamespaceCreateOrUpdateParameters"));
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

