/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.resourcemanager.resources.fluentcore.arm.models.IndependentChildResource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.models.QueueResourceInner;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.QueueAuthorizationRules;
import java.time.Duration;
import java.time.OffsetDateTime;

public interface Queue
extends IndependentChildResource<ServiceBusManager, QueueResourceInner>,
Refreshable<Queue>,
Updatable<Update> {
    public OffsetDateTime createdAt();

    public OffsetDateTime accessedAt();

    public OffsetDateTime updatedAt();

    public long maxSizeInMB();

    public long currentSizeInBytes();

    public boolean isBatchedOperationsEnabled();

    public boolean isDeadLetteringEnabledForExpiredMessages();

    public boolean isExpressEnabled();

    public boolean isPartitioningEnabled();

    public boolean isSessionEnabled();

    public boolean isDuplicateDetectionEnabled();

    public long lockDurationInSeconds();

    public long deleteOnIdleDurationInMinutes();

    public Duration defaultMessageTtlDuration();

    public Duration duplicateMessageDetectionHistoryDuration();

    public int maxDeliveryCountBeforeDeadLetteringMessage();

    public long messageCount();

    public long activeMessageCount();

    public long deadLetterMessageCount();

    public long scheduledMessageCount();

    public long transferDeadLetterMessageCount();

    public long transferMessageCount();

    public EntityStatus status();

    public QueueAuthorizationRules authorizationRules();

    public static interface UpdateStages {

        public static interface WithAuthorizationRule {
            public Update withNewSendRule(String var1);

            public Update withNewListenRule(String var1);

            public Update withNewManageRule(String var1);

            public Update withoutAuthorizationRule(String var1);
        }

        public static interface WithMessageMovedToDeadLetterQueueOnMaxDeliveryCount {
            public Update withMessageMovedToDeadLetterQueueOnMaxDeliveryCount(int var1);
        }

        public static interface WithExpiredMessageMovedToDeadLetterQueue {
            public Update withExpiredMessageMovedToDeadLetterQueue();

            public Update withoutExpiredMessageMovedToDeadLetterQueue();
        }

        public static interface WithDuplicateMessageDetection {
            public Update withDuplicateMessageDetectionHistoryDuration(Duration var1);

            public Update withoutDuplicateMessageDetection();
        }

        public static interface WithMessageBatching {
            public Update withMessageBatching();

            public Update withoutMessageBatching();
        }

        public static interface WithExpressMessage {
            public Update withExpressMessage();

            public Update withoutExpressMessage();
        }

        public static interface WithSession {
            public Update withSession();

            public Update withoutSession();
        }

        public static interface WithDefaultMessageTTL {
            public Update withDefaultMessageTTL(Duration var1);
        }

        public static interface WithMessageLockDuration {
            public Update withMessageLockDurationInSeconds(int var1);
        }

        public static interface WithDeleteOnIdle {
            public Update withDeleteOnIdleDurationInMinutes(int var1);
        }

        public static interface WithSize {
            public Update withSizeInMB(long var1);
        }
    }

    public static interface Update
    extends Appliable<Queue>,
    UpdateStages.WithSize,
    UpdateStages.WithDeleteOnIdle,
    UpdateStages.WithMessageLockDuration,
    UpdateStages.WithDefaultMessageTTL,
    UpdateStages.WithSession,
    UpdateStages.WithExpressMessage,
    UpdateStages.WithMessageBatching,
    UpdateStages.WithDuplicateMessageDetection,
    UpdateStages.WithExpiredMessageMovedToDeadLetterQueue,
    UpdateStages.WithMessageMovedToDeadLetterQueueOnMaxDeliveryCount,
    UpdateStages.WithAuthorizationRule {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Queue>,
        WithSize,
        WithPartitioning,
        WithDeleteOnIdle,
        WithMessageLockDuration,
        WithDefaultMessageTTL,
        WithSession,
        WithExpressMessage,
        WithMessageBatching,
        WithDuplicateMessageDetection,
        WithExpiredMessageMovedToDeadLetterQueue,
        WithMessageMovedToDeadLetterQueueOnMaxDeliveryCount,
        WithAuthorizationRule {
        }

        public static interface WithAuthorizationRule {
            public WithCreate withNewSendRule(String var1);

            public WithCreate withNewListenRule(String var1);

            public WithCreate withNewManageRule(String var1);
        }

        public static interface WithMessageMovedToDeadLetterQueueOnMaxDeliveryCount {
            public WithCreate withMessageMovedToDeadLetterQueueOnMaxDeliveryCount(int var1);
        }

        public static interface WithExpiredMessageMovedToDeadLetterQueue {
            public WithCreate withExpiredMessageMovedToDeadLetterQueue();
        }

        public static interface WithDuplicateMessageDetection {
            public WithCreate withDuplicateMessageDetection(Duration var1);
        }

        public static interface WithMessageBatching {
            public WithCreate withoutMessageBatching();
        }

        public static interface WithExpressMessage {
            public WithCreate withExpressMessage();
        }

        public static interface WithSession {
            public WithCreate withSession();
        }

        public static interface WithDefaultMessageTTL {
            public WithCreate withDefaultMessageTTL(Duration var1);
        }

        public static interface WithMessageLockDuration {
            public WithCreate withMessageLockDurationInSeconds(int var1);
        }

        public static interface WithDeleteOnIdle {
            public WithCreate withDeleteOnIdleDurationInMinutes(int var1);
        }

        public static interface WithPartitioning {
            public WithCreate withPartitioning();

            public WithCreate withoutPartitioning();
        }

        public static interface WithSize {
            public WithCreate withSizeInMB(long var1);
        }

        public static interface Blank
        extends WithCreate {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate {
    }
}

