/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.models.SkuName;
import com.azure.resourcemanager.servicebus.models.SkuTier;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class Sku {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Sku.class);
    @JsonProperty(value="name")
    private SkuName name;
    @JsonProperty(value="tier", required=true)
    private SkuTier tier;
    @JsonProperty(value="capacity")
    private Integer capacity;

    public SkuName name() {
        return this.name;
    }

    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

    public SkuTier tier() {
        return this.tier;
    }

    public Sku withTier(SkuTier tier) {
        this.tier = tier;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public Sku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.tier() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property tier in model Sku"));
        }
    }
}

