/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.models.EntityAvailabilityStatus;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.MessageCountDetails;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

@JsonFlatten
public class SubscriptionCreateOrUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SubscriptionCreateOrUpdateParameters.class);
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="properties.accessedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime accessedAt;
    @JsonProperty(value="properties.autoDeleteOnIdle")
    private String autoDeleteOnIdle;
    @JsonProperty(value="properties.countDetails", access=JsonProperty.Access.WRITE_ONLY)
    private MessageCountDetails countDetails;
    @JsonProperty(value="properties.createdAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;
    @JsonProperty(value="properties.defaultMessageTimeToLive")
    private String defaultMessageTimeToLive;
    @JsonProperty(value="properties.deadLetteringOnFilterEvaluationExceptions")
    private Boolean deadLetteringOnFilterEvaluationExceptions;
    @JsonProperty(value="properties.deadLetteringOnMessageExpiration")
    private Boolean deadLetteringOnMessageExpiration;
    @JsonProperty(value="properties.enableBatchedOperations")
    private Boolean enableBatchedOperations;
    @JsonProperty(value="properties.entityAvailabilityStatus")
    private EntityAvailabilityStatus entityAvailabilityStatus;
    @JsonProperty(value="properties.isReadOnly")
    private Boolean isReadOnly;
    @JsonProperty(value="properties.lockDuration")
    private String lockDuration;
    @JsonProperty(value="properties.maxDeliveryCount")
    private Integer maxDeliveryCount;
    @JsonProperty(value="properties.messageCount", access=JsonProperty.Access.WRITE_ONLY)
    private Long messageCount;
    @JsonProperty(value="properties.requiresSession")
    private Boolean requiresSession;
    @JsonProperty(value="properties.status")
    private EntityStatus status;
    @JsonProperty(value="properties.updatedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAt;

    public String location() {
        return this.location;
    }

    public SubscriptionCreateOrUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public String type() {
        return this.type;
    }

    public SubscriptionCreateOrUpdateParameters withType(String type) {
        this.type = type;
        return this;
    }

    public OffsetDateTime accessedAt() {
        return this.accessedAt;
    }

    public String autoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public SubscriptionCreateOrUpdateParameters withAutoDeleteOnIdle(String autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public MessageCountDetails countDetails() {
        return this.countDetails;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public String defaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public SubscriptionCreateOrUpdateParameters withDefaultMessageTimeToLive(String defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public Boolean deadLetteringOnFilterEvaluationExceptions() {
        return this.deadLetteringOnFilterEvaluationExceptions;
    }

    public SubscriptionCreateOrUpdateParameters withDeadLetteringOnFilterEvaluationExceptions(Boolean deadLetteringOnFilterEvaluationExceptions) {
        this.deadLetteringOnFilterEvaluationExceptions = deadLetteringOnFilterEvaluationExceptions;
        return this;
    }

    public Boolean deadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public SubscriptionCreateOrUpdateParameters withDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public Boolean enableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public SubscriptionCreateOrUpdateParameters withEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public EntityAvailabilityStatus entityAvailabilityStatus() {
        return this.entityAvailabilityStatus;
    }

    public SubscriptionCreateOrUpdateParameters withEntityAvailabilityStatus(EntityAvailabilityStatus entityAvailabilityStatus) {
        this.entityAvailabilityStatus = entityAvailabilityStatus;
        return this;
    }

    public Boolean isReadOnly() {
        return this.isReadOnly;
    }

    public SubscriptionCreateOrUpdateParameters withIsReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        return this;
    }

    public String lockDuration() {
        return this.lockDuration;
    }

    public SubscriptionCreateOrUpdateParameters withLockDuration(String lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public SubscriptionCreateOrUpdateParameters withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public Long messageCount() {
        return this.messageCount;
    }

    public Boolean requiresSession() {
        return this.requiresSession;
    }

    public SubscriptionCreateOrUpdateParameters withRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    public EntityStatus status() {
        return this.status;
    }

    public SubscriptionCreateOrUpdateParameters withStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public void validate() {
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model SubscriptionCreateOrUpdateParameters"));
        }
        if (this.countDetails() != null) {
            this.countDetails().validate();
        }
    }
}

