/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.resourcemanager.resources.fluentcore.arm.models.IndependentChildResource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.models.TopicResourceInner;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.ServiceBusSubscriptions;
import com.azure.resourcemanager.servicebus.models.TopicAuthorizationRules;
import java.time.Duration;
import java.time.OffsetDateTime;

public interface Topic
extends IndependentChildResource<ServiceBusManager, TopicResourceInner>,
Refreshable<Topic>,
Updatable<Update>,
HasInnerModel<TopicResourceInner> {
    public OffsetDateTime createdAt();

    public OffsetDateTime accessedAt();

    public OffsetDateTime updatedAt();

    public long maxSizeInMB();

    public long currentSizeInBytes();

    public boolean isBatchedOperationsEnabled();

    public boolean isExpressEnabled();

    public boolean isPartitioningEnabled();

    public boolean isDuplicateDetectionEnabled();

    public long deleteOnIdleDurationInMinutes();

    public Duration defaultMessageTtlDuration();

    public Duration duplicateMessageDetectionHistoryDuration();

    public long activeMessageCount();

    public long deadLetterMessageCount();

    public long scheduledMessageCount();

    public long transferDeadLetterMessageCount();

    public long transferMessageCount();

    public int subscriptionCount();

    public EntityStatus status();

    public ServiceBusSubscriptions subscriptions();

    public TopicAuthorizationRules authorizationRules();

    public static interface UpdateStages {

        public static interface WithAuthorizationRule {
            public Update withNewSendRule(String var1);

            public Update withNewListenRule(String var1);

            public Update withNewManageRule(String var1);

            public Update withoutAuthorizationRule(String var1);
        }

        public static interface WithSubscription {
            public Update withNewSubscription(String var1);

            public Update withoutSubscription(String var1);
        }

        public static interface WithDuplicateMessageDetection {
            public Update withDuplicateMessageDetectionHistoryDuration(Duration var1);

            public Update withoutDuplicateMessageDetection();
        }

        public static interface WithMessageBatching {
            public Update withMessageBatching();

            public Update withoutMessageBatching();
        }

        public static interface WithExpressMessage {
            public Update withExpressMessage();

            public Update withoutExpressMessage();
        }

        public static interface WithDefaultMessageTTL {
            public Update withDefaultMessageTTL(Duration var1);
        }

        public static interface WithDeleteOnIdle {
            public Update withDeleteOnIdleDurationInMinutes(int var1);
        }

        public static interface WithSize {
            public Update withSizeInMB(long var1);
        }
    }

    public static interface Update
    extends Appliable<Topic>,
    UpdateStages.WithSize,
    UpdateStages.WithDeleteOnIdle,
    UpdateStages.WithDefaultMessageTTL,
    UpdateStages.WithExpressMessage,
    UpdateStages.WithMessageBatching,
    UpdateStages.WithDuplicateMessageDetection,
    UpdateStages.WithSubscription,
    UpdateStages.WithAuthorizationRule {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Topic>,
        WithSize,
        WithPartitioning,
        WithDeleteOnIdle,
        WithDefaultMessageTTL,
        WithExpressMessage,
        WithMessageBatching,
        WithDuplicateMessageDetection,
        WithSubscription,
        WithAuthorizationRule {
        }

        public static interface WithAuthorizationRule {
            public WithCreate withNewSendRule(String var1);

            public WithCreate withNewListenRule(String var1);

            public WithCreate withNewManageRule(String var1);
        }

        public static interface WithSubscription {
            public WithCreate withNewSubscription(String var1);
        }

        public static interface WithDuplicateMessageDetection {
            public WithCreate withDuplicateMessageDetection(Duration var1);
        }

        public static interface WithMessageBatching {
            public WithCreate withoutMessageBatching();
        }

        public static interface WithExpressMessage {
            public WithCreate withExpressMessage();
        }

        public static interface WithDefaultMessageTTL {
            public WithCreate withDefaultMessageTTL(Duration var1);
        }

        public static interface WithDeleteOnIdle {
            public WithCreate withDeleteOnIdleDurationInMinutes(int var1);
        }

        public static interface WithPartitioning {
            public WithCreate withPartitioning();

            public WithCreate withoutPartitioning();
        }

        public static interface WithSize {
            public WithCreate withSizeInMB(long var1);
        }

        public static interface Blank
        extends WithCreate {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate {
    }
}

