/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusManagementClientBuilder;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusNamespacesImpl;
import com.azure.resourcemanager.servicebus.models.ServiceBusNamespaces;

public final class ServiceBusManager
extends Manager<ServiceBusManagementClient> {
    private ServiceBusNamespaces namespaces;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static ServiceBusManager authenticate(TokenCredential credential, AzureProfile profile) {
        return ServiceBusManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    private static ServiceBusManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        return new ServiceBusManager(httpPipeline, profile);
    }

    private ServiceBusManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new ServiceBusManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public ServiceBusNamespaces namespaces() {
        if (this.namespaces == null) {
            this.namespaces = new ServiceBusNamespacesImpl(((ServiceBusManagementClient)this.serviceClient()).getNamespaces(), this);
        }
        return this.namespaces;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public ServiceBusManager authenticate(TokenCredential credential, AzureProfile profile) {
            return ServiceBusManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public ServiceBusManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

